#### HTML template of dialog to create a device or an asset

```html
{:code-style="max-height: 400px;"}
<form #addEntityForm="ngForm" [formGroup]="addEntityFormGroup"
      (ngSubmit)="save()" style="width: 552px">
  <mat-toolbar class="flex flex-row" color="primary">
    <h2>Add entity</h2>
    <span class="flex-1"></span>
    <button mat-icon-button (click)="cancel()" type="button">
      <mat-icon class="material-icons">close</mat-icon>
    </button>
  </mat-toolbar>
  <mat-progress-bar color="warn" mode="indeterminate" *ngIf="isLoading$ | async">
  </mat-progress-bar>
  <div style="height: 4px;" *ngIf="!(isLoading$ | async)"></div>
  <div mat-dialog-content class="flex flex-col" style="padding-bottom: 0">
    <div class="flex flex-row gap-2 xs:flex-col xs:gap-0">
      <mat-form-field class="mat-block flex-1" appearance="outline">
        <mat-label>Entity Name</mat-label>
        <input matInput formControlName="entityName" required>
        <mat-error *ngIf="addEntityFormGroup.get('entityName').hasError('required')">
          Entity name is required.
        </mat-error>
      </mat-form-field>
      <mat-form-field class="mat-block flex-1" appearance="outline">
        <mat-label>Entity Label</mat-label>
        <input matInput formControlName="entityLabel" >
      </mat-form-field>
    </div>
    <div class="flex flex-row gap-2 xs:flex-col xs:gap-0">
      <tb-entity-type-select
        class="mat-block flex-1"
        formControlName="entityType"
        [showLabel]="true"
        [appearance]="'outline'"
        [allowedEntityTypes]="allowedEntityTypes"
      ></tb-entity-type-select>
      <tb-entity-subtype-autocomplete
        *ngIf="addEntityFormGroup.get('entityType').value == 'ASSET'"
        class="mat-block flex-1"
        formControlName="type"
        [required]="true"
        [entityType]="'ASSET'"
        [appearance]="'outline'"
      ></tb-entity-subtype-autocomplete>
      <tb-entity-subtype-autocomplete
        *ngIf="addEntityFormGroup.get('entityType').value != 'ASSET'"
        class="mat-block flex-1"
        formControlName="type"
        [required]="true"
        [entityType]="'DEVICE'"
        [appearance]="'outline'"
      ></tb-entity-subtype-autocomplete>
    </div>
    <div formGroupName="attributes" class="flex flex-col">
      <div class="flex flex-row gap-2 xs:flex-col xs:gap-0">
        <mat-form-field class="mat-block flex-1" appearance="outline">
          <mat-label>Address</mat-label>
          <input matInput formControlName="address">
        </mat-form-field>
        <mat-form-field class="mat-block flex-1" appearance="outline">
          <mat-label>Owner</mat-label>
          <input matInput formControlName="owner">
        </mat-form-field>
      </div>
    </div>
  </div>
  <div mat-dialog-actions class="flex flex-row items-center justify-end">
    <button mat-button color="primary"
            type="button"
            [disabled]="(isLoading$ | async)"
            (click)="cancel()" cdkFocusInitial>
      Cancel
    </button>
    <button mat-button mat-raised-button color="primary"
            type="submit"
            [disabled]="(isLoading$ | async) || addEntityForm.invalid || !addEntityForm.dirty">
      Create
    </button>
  </div>
</form>
{:copy-code}
```

<br>
<br>
