/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.client.tools.migrator;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;

public class RelatedEntitiesParser {
    private final Map<String, String> allEntityIdsAndTypes = new HashMap<String, String>();
    private final Map<String, EntityType> tableNameAndEntityType = Map.ofEntries(Map.entry("COPY public.alarm ", EntityType.ALARM), Map.entry("COPY public.asset ", EntityType.ASSET), Map.entry("COPY public.customer ", EntityType.CUSTOMER), Map.entry("COPY public.dashboard ", EntityType.DASHBOARD), Map.entry("COPY public.device ", EntityType.DEVICE), Map.entry("COPY public.rule_chain ", EntityType.RULE_CHAIN), Map.entry("COPY public.rule_node ", EntityType.RULE_NODE), Map.entry("COPY public.tenant ", EntityType.TENANT), Map.entry("COPY public.tb_user ", EntityType.USER), Map.entry("COPY public.entity_view ", EntityType.ENTITY_VIEW), Map.entry("COPY public.widgets_bundle ", EntityType.WIDGETS_BUNDLE), Map.entry("COPY public.widget_type ", EntityType.WIDGET_TYPE), Map.entry("COPY public.tenant_profile ", EntityType.TENANT_PROFILE), Map.entry("COPY public.device_profile ", EntityType.DEVICE_PROFILE), Map.entry("COPY public.asset_profile ", EntityType.ASSET_PROFILE), Map.entry("COPY public.api_usage_state ", EntityType.API_USAGE_STATE));

    public RelatedEntitiesParser(File source) throws IOException {
        this.processAllTables(FileUtils.lineIterator((File)source));
    }

    public String getEntityType(String uuid) {
        return this.allEntityIdsAndTypes.get(uuid);
    }

    private boolean isBlockFinished(String line) {
        return StringUtils.isBlank((String)line) || line.equals("\\.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAllTables(LineIterator lineIterator) throws IOException {
        try {
            while (lineIterator.hasNext()) {
                String currentLine = lineIterator.nextLine();
                for (Map.Entry<String, EntityType> entry : this.tableNameAndEntityType.entrySet()) {
                    if (!currentLine.startsWith(entry.getKey())) continue;
                    this.processBlock(lineIterator, entry.getValue());
                }
            }
        }
        finally {
            lineIterator.close();
        }
    }

    private void processBlock(LineIterator lineIterator, EntityType entityType) {
        while (lineIterator.hasNext()) {
            String currentLine = lineIterator.nextLine();
            if (this.isBlockFinished(currentLine)) {
                return;
            }
            this.allEntityIdsAndTypes.put(currentLine.split("\t")[0], entityType.name());
        }
    }
}

