/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.client.tools.migrator;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.thingsboard.server.common.data.StringUtils;

public class DictionaryParser {
    private Map<String, String> dictionaryParsed = new HashMap<String, String>();

    public DictionaryParser(File sourceFile) throws IOException {
        this.parseDictionaryDump(FileUtils.lineIterator((File)sourceFile));
    }

    public String getKeyByKeyId(String keyId) {
        return this.dictionaryParsed.get(keyId);
    }

    private boolean isBlockFinished(String line) {
        return StringUtils.isBlank((String)line) || line.equals("\\.");
    }

    private boolean isBlockStarted(String line) {
        return line.startsWith("COPY public.key_dictionary (");
    }

    private void parseDictionaryDump(LineIterator iterator) throws IOException {
        try {
            while (iterator.hasNext()) {
                String tempLine = iterator.nextLine();
                if (!this.isBlockStarted(tempLine)) continue;
                this.processBlock(iterator);
            }
        }
        finally {
            iterator.close();
        }
    }

    private void processBlock(LineIterator lineIterator) {
        while (lineIterator.hasNext()) {
            String tempLine = lineIterator.nextLine();
            if (this.isBlockFinished(tempLine)) {
                return;
            }
            String[] lineSplited = tempLine.split("\t");
            this.dictionaryParsed.put(lineSplited[1], lineSplited[0]);
        }
    }
}

