/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.client.tools.i18n;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TranslationPruner {
    private static void collectKeys(JsonNode node, String prefix, Set<String> keys) {
        if (!node.isObject()) {
            return;
        }
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            String fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            keys.add(fullKey);
            TranslationPruner.collectKeys((JsonNode)entry.getValue(), fullKey, keys);
        }
    }

    private static ObjectNode pruneNode(ObjectNode node, Set<String> keys, String prefix, ObjectMapper mapper) {
        ObjectNode pruned = mapper.createObjectNode();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            Object fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (!keys.contains(fullKey)) continue;
            if (value.isObject()) {
                ObjectNode child = TranslationPruner.pruneNode((ObjectNode)value, keys, (String)fullKey, mapper);
                pruned.set(key, (JsonNode)child);
                continue;
            }
            pruned.set(key, value);
        }
        return pruned;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: `java TranslationPruner <source folder> <dest folder>`, where dest folder must contain the locale.constant-en_US.json for reference structure.");
            System.exit(1);
        }
        try {
            File sourceFolder = new File(args[0]);
            File destFolder = new File(args[1]);
            File referenceFile = new File(destFolder, "locale.constant-en_US.json");
            ObjectMapper mapper = new ObjectMapper();
            JsonNode usRoot = mapper.readTree(referenceFile);
            HashSet<String> validKeys = new HashSet<String>();
            TranslationPruner.collectKeys(usRoot, "", validKeys);
            for (File sourceFile : sourceFolder.listFiles()) {
                File destFile = new File(destFolder, sourceFile.getName());
                JsonNode sourceRoot = mapper.readTree(sourceFile);
                if (!sourceRoot.isObject()) {
                    throw new IllegalArgumentException("Source JSON must be an object at root");
                }
                ObjectNode pruned = TranslationPruner.pruneNode((ObjectNode)sourceRoot, validKeys, "", mapper);
                Separators seps = Separators.createDefaultInstance().withObjectFieldValueSpacing(Separators.Spacing.AFTER);
                mapper.writer((PrettyPrinter)new DefaultPrettyPrinter().withSeparators(seps)).writeValue(destFile, (Object)pruned);
                System.out.println("Pruned translation written to " + destFile.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

