/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.client.tools.migrator;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.math.NumberUtils;
import org.thingsboard.client.tools.migrator.DictionaryParser;
import org.thingsboard.client.tools.migrator.RelatedEntitiesParser;
import org.thingsboard.client.tools.migrator.WriterBuilder;
import org.thingsboard.server.common.data.StringUtils;

public class PgCaMigrator {
    private final long LOG_BATCH = 1000000L;
    private final long rowPerFile = 1000000L;
    private long linesTsMigrated = 0L;
    private long linesLatestMigrated = 0L;
    private long castErrors = 0L;
    private long castedOk = 0L;
    private long currentWriterCount = 1L;
    private final File sourceFile;
    private final boolean castStringIfPossible;
    private final RelatedEntitiesParser entityIdsAndTypes;
    private final DictionaryParser keyParser;
    private CQLSSTableWriter currentTsWriter;
    private CQLSSTableWriter currentPartitionsWriter;
    private CQLSSTableWriter currentTsLatestWriter;
    private final Set<String> partitions = new HashSet<String>();
    private File outTsDir;
    private File outTsLatestDir;

    public PgCaMigrator(File sourceFile, File ourTsDir, File outTsPartitionDir, File outTsLatestDir, RelatedEntitiesParser allEntityIdsAndTypes, DictionaryParser dictionaryParser, boolean castStringsIfPossible) {
        this.sourceFile = sourceFile;
        this.entityIdsAndTypes = allEntityIdsAndTypes;
        this.keyParser = dictionaryParser;
        this.castStringIfPossible = castStringsIfPossible;
        if (outTsLatestDir != null) {
            this.currentTsLatestWriter = WriterBuilder.getLatestWriter(outTsLatestDir);
            this.outTsLatestDir = outTsLatestDir;
        }
        if (ourTsDir != null) {
            this.currentTsWriter = WriterBuilder.getTsWriter(ourTsDir);
            this.currentPartitionsWriter = WriterBuilder.getPartitionWriter(outTsPartitionDir);
            this.outTsDir = ourTsDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate() throws IOException {
        boolean isTsDone = false;
        boolean isLatestDone = false;
        LineIterator iterator = FileUtils.lineIterator((File)this.sourceFile);
        try {
            while (iterator.hasNext()) {
                long start;
                String line = iterator.nextLine();
                if (!isLatestDone && this.isBlockLatestStarted(line)) {
                    System.out.println("START TO MIGRATE LATEST");
                    start = System.currentTimeMillis();
                    this.processBlock(iterator, this.currentTsLatestWriter, this.outTsLatestDir, this::toValuesLatest);
                    System.out.println("TOTAL LINES MIGRATED: " + this.linesLatestMigrated + ", FORMING OF SSL FOR LATEST TS FINISHED WITH TIME: " + (System.currentTimeMillis() - start) + " ms.");
                    isLatestDone = true;
                }
                if (isTsDone || !this.isBlockTsStarted(line)) continue;
                System.out.println("START TO MIGRATE TS");
                start = System.currentTimeMillis();
                this.processBlock(iterator, this.currentTsWriter, this.outTsDir, this::toValuesTs);
                System.out.println("TOTAL LINES MIGRATED: " + this.linesTsMigrated + ", FORMING OF SSL FOR TS FINISHED WITH TIME: " + (System.currentTimeMillis() - start) + " ms.");
                isTsDone = true;
            }
            System.out.println("Partitions collected " + this.partitions.size());
            long startTs = System.currentTimeMillis();
            for (String partition : this.partitions) {
                String[] split = partition.split("\\|");
                ArrayList values = Lists.newArrayList();
                values.add(split[0]);
                values.add(UUID.fromString(split[1]));
                values.add(split[2]);
                values.add(Long.parseLong(split[3]));
                this.currentPartitionsWriter.addRow((List)values);
            }
            System.out.println(new Date() + " Migrated partitions " + this.partitions.size() + " in " + (System.currentTimeMillis() - startTs));
            System.out.println();
            System.out.println("Finished migrate Telemetry");
        }
        finally {
            iterator.close();
            this.currentTsLatestWriter.close();
            this.currentTsWriter.close();
            this.currentPartitionsWriter.close();
        }
    }

    private void logLinesProcessed(long lines) {
        if (lines % 1000000L == 0L) {
            System.out.println(new Date() + " lines processed = " + lines + " in, castOk " + this.castedOk + "  castErr " + this.castErrors);
        }
    }

    private void logLinesMigrated(long lines) {
        if (lines % 1000000L == 0L) {
            System.out.println(new Date() + " lines migrated = " + lines + " in, castOk " + this.castedOk + "  castErr " + this.castErrors);
        }
    }

    private void addTypeIdKey(List<Object> result, List<String> raw) {
        result.add(this.entityIdsAndTypes.getEntityType(raw.get(0)));
        result.add(UUID.fromString(raw.get(0)));
        result.add(this.keyParser.getKeyByKeyId(raw.get(1)));
    }

    private void addPartitions(List<Object> result, List<String> raw) {
        long ts = Long.parseLong(raw.get(2));
        long partition = this.toPartitionTs(ts);
        result.add(partition);
        result.add(ts);
    }

    private void addTimeseries(List<Object> result, List<String> raw) {
        result.add(Long.parseLong(raw.get(2)));
    }

    private void addValues(List<Object> result, List<String> raw) {
        result.add(raw.get(3).equals("\\N") ? null : (raw.get(3).equals("t") ? Boolean.TRUE : Boolean.FALSE));
        result.add(raw.get(4).equals("\\N") ? null : raw.get(4));
        result.add(raw.get(5).equals("\\N") ? null : Long.valueOf(Long.parseLong(raw.get(5))));
        result.add(raw.get(6).equals("\\N") ? null : Double.valueOf(Double.parseDouble(raw.get(6))));
        result.add(raw.get(7).equals("\\N") ? null : raw.get(7));
    }

    private List<Object> toValuesTs(List<String> raw) {
        this.logLinesMigrated(this.linesTsMigrated++);
        ArrayList<Object> result = new ArrayList<Object>();
        this.addTypeIdKey(result, raw);
        this.addPartitions(result, raw);
        this.addValues(result, raw);
        this.processPartitions(result);
        return result;
    }

    private List<Object> toValuesLatest(List<String> raw) {
        this.logLinesMigrated(this.linesLatestMigrated++);
        ArrayList<Object> result = new ArrayList<Object>();
        this.addTypeIdKey(result, raw);
        this.addTimeseries(result, raw);
        this.addValues(result, raw);
        return result;
    }

    private long toPartitionTs(long ts) {
        LocalDateTime time = LocalDateTime.ofInstant(Instant.ofEpochMilli(ts), ZoneOffset.UTC);
        return time.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1).toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    private void processPartitions(List<Object> values) {
        String key = values.get(0) + "|" + values.get(1) + "|" + values.get(2) + "|" + values.get(3);
        this.partitions.add(key);
    }

    private void processBlock(LineIterator iterator, CQLSSTableWriter writer, File outDir, Function<List<String>, List<Object>> function) {
        long linesProcessed = 0L;
        while (iterator.hasNext()) {
            this.logLinesProcessed(linesProcessed++);
            String currentLine = iterator.nextLine();
            if (this.isBlockFinished(currentLine)) {
                return;
            }
            try {
                List raw = Arrays.stream(currentLine.trim().split("\t")).map(String::trim).collect(Collectors.toList());
                List<Object> values = function.apply(raw);
                if (this.currentWriterCount == 0L) {
                    System.out.println(new Date() + " close writer " + new Date());
                    writer.close();
                    writer = WriterBuilder.getLatestWriter(outDir);
                }
                if (this.castStringIfPossible) {
                    writer.addRow(this.castToNumericIfPossible(values));
                } else {
                    writer.addRow(values);
                }
                ++this.currentWriterCount;
                if (this.currentWriterCount < 1000000L) continue;
                this.currentWriterCount = 0L;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage() + " -> " + currentLine);
            }
        }
    }

    private List<Object> castToNumericIfPossible(List<Object> values) {
        try {
            if (values.get(6) != null && NumberUtils.isNumber((String)values.get(6).toString())) {
                Double casted = NumberUtils.createDouble((String)values.get(6).toString());
                ArrayList numeric = Lists.newArrayList();
                numeric.addAll(values);
                numeric.set(6, null);
                numeric.set(8, casted);
                ++this.castedOk;
                return numeric;
            }
        }
        catch (Throwable th) {
            ++this.castErrors;
        }
        this.processPartitions(values);
        return values;
    }

    private boolean isBlockFinished(String line) {
        return StringUtils.isBlank((String)line) || line.equals("\\.");
    }

    private boolean isBlockTsStarted(String line) {
        return line.startsWith("COPY public.ts_kv (");
    }

    private boolean isBlockLatestStarted(String line) {
        return line.startsWith("COPY public.ts_kv_latest (");
    }
}

