/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.client.tools;

import java.security.KeyStore;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.ResourceUtils;

public class MqttSslClient {
    private static final Logger log = LoggerFactory.getLogger(MqttSslClient.class);
    private static final String MQTT_URL = "ssl://localhost:1883";
    private static final String CLIENT_ID = "MQTT_SSL_JAVA_CLIENT";
    private static final String KEY_STORE_FILE = "mqttclient.jks";
    private static final String JKS = "JKS";
    private static final String TLS = "TLS";

    public static void main(String[] args) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance(JKS);
            char[] ksPwd = new char[]{'c', 'l', 'i', 'e', 'n', 't', '_', 'k', 's', '_', 'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
            trustStore.load(ResourceUtils.getInputStream((ClassLoader)MqttSslClient.class.getClassLoader(), (String)KEY_STORE_FILE), ksPwd);
            tmf.init(trustStore);
            KeyStore ks = KeyStore.getInstance(JKS);
            ks.load(ResourceUtils.getInputStream((ClassLoader)MqttSslClient.class.getClassLoader(), (String)KEY_STORE_FILE), ksPwd);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] clientPwd = new char[]{'c', 'l', 'i', 'e', 'n', 't', '_', 'k', 'e', 'y', '_', 'p', 'a', 's', 's', 'w', 'o', 'r', 'd'};
            kmf.init(ks, clientPwd);
            KeyManager[] km = kmf.getKeyManagers();
            TrustManager[] tm = tmf.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance(TLS);
            sslContext.init(km, tm, null);
            MqttConnectOptions options = new MqttConnectOptions();
            options.setSocketFactory((SocketFactory)sslContext.getSocketFactory());
            MqttAsyncClient client = new MqttAsyncClient(MQTT_URL, CLIENT_ID, (MqttClientPersistence)new MemoryPersistence());
            client.connect(options);
            Thread.sleep(3000L);
            MqttMessage message = new MqttMessage();
            message.setPayload("{\"key1\":\"value1\", \"key2\":true, \"key3\": 3.0, \"key4\": 4}".getBytes());
            client.publish("v1/devices/me/telemetry", message);
            client.disconnect();
            log.info("Disconnected");
            System.exit(0);
        }
        catch (Exception e) {
            log.error("Unexpected exception occurred in MqttSslClient", (Throwable)e);
        }
    }
}

