/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.apache.commons.collections.CollectionUtils;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.data.RelationsQuery;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;
import org.thingsboard.server.dao.relation.RelationService;

public class EntitiesRelatedEntityIdAsyncLoader {
    public static ListenableFuture<EntityId> findEntityAsync(TbContext ctx, EntityId originator, RelationsQuery relationsQuery) {
        RelationService relationService = ctx.getRelationService();
        EntityRelationsQuery query = EntitiesRelatedEntityIdAsyncLoader.buildQuery(originator, relationsQuery);
        ListenableFuture relationListFuture = relationService.findByQuery(ctx.getTenantId(), query);
        if (relationsQuery.getDirection() == EntitySearchDirection.FROM) {
            return Futures.transformAsync((ListenableFuture)relationListFuture, relationList -> CollectionUtils.isNotEmpty((Collection)relationList) ? Futures.immediateFuture((Object)((EntityRelation)relationList.get(0)).getTo()) : Futures.immediateFuture(null), (Executor)ctx.getDbCallbackExecutor());
        }
        if (relationsQuery.getDirection() == EntitySearchDirection.TO) {
            return Futures.transformAsync((ListenableFuture)relationListFuture, relationList -> CollectionUtils.isNotEmpty((Collection)relationList) ? Futures.immediateFuture((Object)((EntityRelation)relationList.get(0)).getFrom()) : Futures.immediateFuture(null), (Executor)ctx.getDbCallbackExecutor());
        }
        return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Unknown direction"));
    }

    private static EntityRelationsQuery buildQuery(EntityId originator, RelationsQuery relationsQuery) {
        EntityRelationsQuery query = new EntityRelationsQuery();
        RelationsSearchParameters parameters = new RelationsSearchParameters(originator, relationsQuery.getDirection(), relationsQuery.getMaxLevel(), relationsQuery.isFetchLastLevelOnly());
        query.setParameters(parameters);
        query.setFilters(relationsQuery.getFilters());
        return query;
    }
}

