/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.EntityFieldsData;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.UserId;

public class EntitiesFieldsAsyncLoader {
    public static ListenableFuture<EntityFieldsData> findAsync(TbContext ctx, EntityId originatorId) {
        switch (originatorId.getEntityType()) {
            case TENANT: {
                return EntitiesFieldsAsyncLoader.toEntityFieldsDataAsync(ctx.getTenantService().findTenantByIdAsync(ctx.getTenantId(), (TenantId)originatorId), EntityFieldsData::new, ctx);
            }
            case CUSTOMER: {
                return EntitiesFieldsAsyncLoader.toEntityFieldsDataAsync(ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), (CustomerId)originatorId), EntityFieldsData::new, ctx);
            }
            case USER: {
                return EntitiesFieldsAsyncLoader.toEntityFieldsDataAsync(ctx.getUserService().findUserByIdAsync(ctx.getTenantId(), (UserId)originatorId), EntityFieldsData::new, ctx);
            }
            case ASSET: {
                return EntitiesFieldsAsyncLoader.toEntityFieldsDataAsync(ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), (AssetId)originatorId), EntityFieldsData::new, ctx);
            }
            case DEVICE: {
                return EntitiesFieldsAsyncLoader.toEntityFieldsDataAsync(Futures.immediateFuture((Object)ctx.getDeviceService().findDeviceById(ctx.getTenantId(), (DeviceId)originatorId)), EntityFieldsData::new, ctx);
            }
            case ALARM: {
                return EntitiesFieldsAsyncLoader.toEntityFieldsDataAsync(ctx.getAlarmService().findAlarmByIdAsync(ctx.getTenantId(), (AlarmId)originatorId), EntityFieldsData::new, ctx);
            }
            case RULE_CHAIN: {
                return EntitiesFieldsAsyncLoader.toEntityFieldsDataAsync(ctx.getRuleChainService().findRuleChainByIdAsync(ctx.getTenantId(), (RuleChainId)originatorId), EntityFieldsData::new, ctx);
            }
            case ENTITY_VIEW: {
                return EntitiesFieldsAsyncLoader.toEntityFieldsDataAsync(ctx.getEntityViewService().findEntityViewByIdAsync(ctx.getTenantId(), (EntityViewId)originatorId), EntityFieldsData::new, ctx);
            }
            case EDGE: {
                return EntitiesFieldsAsyncLoader.toEntityFieldsDataAsync(ctx.getEdgeService().findEdgeByIdAsync(ctx.getTenantId(), (EdgeId)originatorId), EntityFieldsData::new, ctx);
            }
        }
        return Futures.immediateFailedFuture((Throwable)new TbNodeException("Unexpected originator EntityType: " + originatorId.getEntityType()));
    }

    private static <T extends BaseData<? extends UUIDBased>> ListenableFuture<EntityFieldsData> toEntityFieldsDataAsync(ListenableFuture<T> future, Function<T, EntityFieldsData> converter, TbContext ctx) {
        return Futures.transformAsync(future, in -> in != null ? Futures.immediateFuture((Object)((EntityFieldsData)converter.apply(in))) : Futures.immediateFailedFuture((Throwable)new NoSuchElementException("Entity not found!")), (Executor)ctx.getDbCallbackExecutor());
    }
}

