/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.util;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.UserId;

public class EntitiesCustomerIdAsyncLoader {
    public static ListenableFuture<CustomerId> findEntityIdAsync(TbContext ctx, EntityId originator) {
        switch (originator.getEntityType()) {
            case CUSTOMER: {
                return Futures.immediateFuture((Object)((CustomerId)originator));
            }
            case USER: {
                return EntitiesCustomerIdAsyncLoader.toCustomerIdAsync(ctx, ctx.getUserService().findUserByIdAsync(ctx.getTenantId(), (UserId)originator));
            }
            case ASSET: {
                return EntitiesCustomerIdAsyncLoader.toCustomerIdAsync(ctx, ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), (AssetId)originator));
            }
            case DEVICE: {
                return EntitiesCustomerIdAsyncLoader.toCustomerIdAsync(ctx, Futures.immediateFuture((Object)ctx.getDeviceService().findDeviceById(ctx.getTenantId(), (DeviceId)originator)));
            }
        }
        return Futures.immediateFailedFuture((Throwable)new TbNodeException("Unexpected originator EntityType: " + originator.getEntityType()));
    }

    private static <T extends HasCustomerId> ListenableFuture<CustomerId> toCustomerIdAsync(TbContext ctx, ListenableFuture<T> future) {
        return Futures.transform(future, in -> in != null ? in.getCustomerId() : null, (Executor)ctx.getDbCallbackExecutor());
    }
}

