/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.util;

import java.util.List;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.EntityId;

public class EntitiesByNameAndTypeLoader {
    private static final List<EntityType> AVAILABLE_ENTITY_TYPES = List.of(EntityType.DEVICE, EntityType.ASSET, EntityType.ENTITY_VIEW, EntityType.EDGE, EntityType.USER);

    public static EntityId findEntityId(TbContext ctx, EntityType entityType, String entityName) {
        Device targetEntity;
        switch (entityType) {
            case DEVICE: {
                targetEntity = ctx.getDeviceService().findDeviceByTenantIdAndName(ctx.getTenantId(), entityName);
                break;
            }
            case ASSET: {
                targetEntity = ctx.getAssetService().findAssetByTenantIdAndName(ctx.getTenantId(), entityName);
                break;
            }
            case ENTITY_VIEW: {
                targetEntity = ctx.getEntityViewService().findEntityViewByTenantIdAndName(ctx.getTenantId(), entityName);
                break;
            }
            case EDGE: {
                targetEntity = ctx.getEdgeService().findEdgeByTenantIdAndName(ctx.getTenantId(), entityName);
                break;
            }
            case USER: {
                targetEntity = ctx.getUserService().findUserByTenantIdAndEmail(ctx.getTenantId(), entityName);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected entity type " + entityType.name());
            }
        }
        if (targetEntity == null) {
            throw new IllegalStateException("Failed to found " + entityType.name() + "  entity by name: '" + entityName + "'!");
        }
        return (EntityId)targetEntity.getId();
    }

    public static void checkEntityType(EntityType entityType) {
        if (!AVAILABLE_ENTITY_TYPES.contains(entityType)) {
            throw new IllegalStateException("Unexpected entity type " + entityType.name());
        }
    }
}

