/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbAbstractTransformNodeWithTbMsgSource;
import org.thingsboard.rule.engine.transform.TbRenameKeysNodeConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.TRANSFORMATION, name="rename keys", version=2, configClazz=TbRenameKeysNodeConfiguration.class, nodeDescription="Renames message or message metadata keys.", nodeDetails="Renames keys in the message or message metadata according to the provided mapping. If key to rename doesn't exist in the specified source (message or message metadata) it will be ignored.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeRenameKeysConfig", icon="find_replace")
public class TbRenameKeysNode
extends TbAbstractTransformNodeWithTbMsgSource {
    private static final Logger log = LoggerFactory.getLogger(TbRenameKeysNode.class);
    private TbRenameKeysNodeConfiguration config;
    private Map<String, String> renameKeysMapping;
    private TbMsgSource renameIn;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbRenameKeysNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbRenameKeysNodeConfiguration.class);
        this.renameIn = this.config.getRenameIn();
        this.renameKeysMapping = this.config.getRenameKeysMapping();
        if (this.renameIn == null) {
            throw new TbNodeException("RenameIn can't be null! Allowed values: " + Arrays.toString((Object[])TbMsgSource.values()));
        }
        if (this.renameKeysMapping == null || this.renameKeysMapping.isEmpty()) {
            throw new TbNodeException("At least one mapping entry should be specified!");
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        TbMsgMetaData metaDataCopy = msg.getMetaData().copy();
        String data = msg.getData();
        boolean msgChanged = false;
        switch (this.renameIn) {
            case METADATA: {
                Map metaDataMap = metaDataCopy.getData();
                for (Map.Entry<String, String> entry : this.renameKeysMapping.entrySet()) {
                    String currentKeyName = entry.getKey();
                    String newKeyName = entry.getValue();
                    if (!metaDataMap.containsKey(currentKeyName)) continue;
                    msgChanged = true;
                    String value = (String)metaDataMap.get(currentKeyName);
                    metaDataMap.put(newKeyName, value);
                    metaDataMap.remove(currentKeyName);
                }
                metaDataCopy = new TbMsgMetaData(metaDataMap);
                break;
            }
            case DATA: {
                JsonNode dataNode = JacksonUtil.toJsonNode((String)data);
                if (!dataNode.isObject()) break;
                ObjectNode msgData = (ObjectNode)dataNode;
                for (Map.Entry<String, String> entry : this.renameKeysMapping.entrySet()) {
                    String currentKeyName = entry.getKey();
                    String newKeyName = entry.getValue();
                    if (!msgData.has(currentKeyName)) continue;
                    msgChanged = true;
                    JsonNode value = msgData.get(currentKeyName);
                    msgData.set(newKeyName, value);
                    msgData.remove(currentKeyName);
                }
                data = JacksonUtil.toString((Object)msgData);
                break;
            }
            default: {
                log.debug("Unexpected RenameIn value: {}. Allowed values: {}", (Object)this.renameIn, (Object)TbMsgSource.values());
            }
        }
        ctx.tellSuccess(msgChanged ? TbMsg.transformMsg((TbMsg)msg, (TbMsgMetaData)metaDataCopy, (String)data) : msg);
    }

    @Override
    protected String getNewKeyForUpgradeFromVersionZero() {
        return "renameIn";
    }

    @Override
    protected String getKeyToUpgradeFromVersionOne() {
        return "fromMetadata";
    }
}

