/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbAbstractTransformNodeWithTbMsgSource;
import org.thingsboard.rule.engine.transform.TbDeleteKeysNodeConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.TRANSFORMATION, name="delete key-value pairs", version=2, configClazz=TbDeleteKeysNodeConfiguration.class, nodeDescription="Deletes key-value pairs from message or message metadata.", nodeDetails="Deletes key-value pairs from the message or message metadata according to the configured keys and/or regular expressions.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeDeleteKeysConfig", icon="remove_circle")
public class TbDeleteKeysNode
extends TbAbstractTransformNodeWithTbMsgSource {
    private static final Logger log = LoggerFactory.getLogger(TbDeleteKeysNode.class);
    private TbDeleteKeysNodeConfiguration config;
    private TbMsgSource deleteFrom;
    private List<Pattern> compiledKeyPatterns;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbDeleteKeysNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbDeleteKeysNodeConfiguration.class);
        this.deleteFrom = this.config.getDeleteFrom();
        if (this.deleteFrom == null) {
            throw new TbNodeException("DeleteFrom can't be null! Allowed values: " + Arrays.toString((Object[])TbMsgSource.values()));
        }
        this.compiledKeyPatterns = this.config.getKeys().stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        TbMsgMetaData metaDataCopy = msg.getMetaData().copy();
        String msgDataStr = msg.getData();
        boolean hasNoChanges = false;
        switch (this.deleteFrom) {
            case METADATA: {
                Map metaDataMap = metaDataCopy.getData();
                List<String> mdKeysToDelete = metaDataMap.keySet().stream().filter(this::matches).collect(Collectors.toList());
                mdKeysToDelete.forEach(metaDataMap::remove);
                metaDataCopy = new TbMsgMetaData(metaDataMap);
                hasNoChanges = mdKeysToDelete.isEmpty();
                break;
            }
            case DATA: {
                JsonNode dataNode = JacksonUtil.toJsonNode((String)msgDataStr);
                if (!dataNode.isObject()) break;
                ObjectNode msgDataObject = (ObjectNode)dataNode;
                ArrayList msgKeysToDelete = new ArrayList();
                dataNode.fieldNames().forEachRemaining(key -> {
                    if (this.matches((String)key)) {
                        msgKeysToDelete.add(key);
                    }
                });
                msgDataObject.remove(msgKeysToDelete);
                msgDataStr = JacksonUtil.toString((Object)msgDataObject);
                hasNoChanges = msgKeysToDelete.isEmpty();
                break;
            }
            default: {
                log.debug("Unexpected DeleteFrom value: {}. Allowed values: {}", (Object)this.deleteFrom, (Object)TbMsgSource.values());
            }
        }
        ctx.tellSuccess(hasNoChanges ? msg : TbMsg.transformMsg((TbMsg)msg, (TbMsgMetaData)metaDataCopy, (String)msgDataStr));
    }

    @Override
    protected String getNewKeyForUpgradeFromVersionZero() {
        return "deleteFrom";
    }

    @Override
    protected String getKeyToUpgradeFromVersionOne() {
        return "dataToFetch";
    }

    boolean matches(String key) {
        return this.compiledKeyPatterns.stream().anyMatch(pattern -> pattern.matcher(key).matches());
    }
}

