/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbAbstractTransformNodeWithTbMsgSource;
import org.thingsboard.rule.engine.transform.TbCopyKeysNodeConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.TRANSFORMATION, name="copy key-value pairs", version=2, configClazz=TbCopyKeysNodeConfiguration.class, nodeDescription="Copies key-value pairs from message to message metadata or vice-versa.", nodeDetails="Copies key-value pairs from the message to message metadata, or vice-versa, according to the configured direction and keys. Regular expressions can be used to define which keys-value pairs to copy. Any configured key not found in the source will be ignored.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeCopyKeysConfig", icon="content_copy")
public class TbCopyKeysNode
extends TbAbstractTransformNodeWithTbMsgSource {
    private static final Logger log = LoggerFactory.getLogger(TbCopyKeysNode.class);
    private TbCopyKeysNodeConfiguration config;
    private TbMsgSource copyFrom;
    private List<Pattern> compiledKeyPatterns;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbCopyKeysNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCopyKeysNodeConfiguration.class);
        this.copyFrom = this.config.getCopyFrom();
        if (this.copyFrom == null) {
            throw new TbNodeException("CopyFrom can't be null! Allowed values: " + Arrays.toString((Object[])TbMsgSource.values()));
        }
        this.compiledKeyPatterns = this.config.getKeys().stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        TbMsgMetaData metaDataCopy = msg.getMetaData().copy();
        String msgData = msg.getData();
        boolean msgChanged = false;
        JsonNode dataNode = JacksonUtil.toJsonNode((String)msgData);
        if (dataNode.isObject()) {
            switch (this.copyFrom) {
                case METADATA: {
                    ObjectNode msgDataNode = (ObjectNode)dataNode;
                    Map metaDataMap = metaDataCopy.getData();
                    for (Map.Entry entry : metaDataMap.entrySet()) {
                        String mdKey = (String)entry.getKey();
                        String mdValue = (String)entry.getValue();
                        if (!this.matches(mdKey)) continue;
                        msgChanged = true;
                        msgDataNode.put(mdKey, mdValue);
                    }
                    msgData = JacksonUtil.toString((Object)msgDataNode);
                    break;
                }
                case DATA: {
                    Iterator iteratorNode = dataNode.fields();
                    while (iteratorNode.hasNext()) {
                        Map.Entry entry = (Map.Entry)iteratorNode.next();
                        String msgKey = (String)entry.getKey();
                        JsonNode msgValue = (JsonNode)entry.getValue();
                        if (!this.matches(msgKey)) continue;
                        msgChanged = true;
                        String value = msgValue.isTextual() ? msgValue.asText() : JacksonUtil.toString((Object)msgValue);
                        metaDataCopy.putValue(msgKey, value);
                    }
                    break;
                }
                default: {
                    log.debug("Unexpected CopyFrom value: {}. Allowed values: {}", (Object)this.copyFrom, (Object)TbMsgSource.values());
                }
            }
        }
        ctx.tellSuccess(msgChanged ? TbMsg.transformMsg((TbMsg)msg, (TbMsgMetaData)metaDataCopy, (String)msgData) : msg);
    }

    @Override
    protected String getNewKeyForUpgradeFromVersionZero() {
        return "copyFrom";
    }

    @Override
    protected String getKeyToUpgradeFromVersionOne() {
        return "fromMetadata";
    }

    boolean matches(String key) {
        return this.compiledKeyPatterns.stream().anyMatch(pattern -> pattern.matcher(key).matches());
    }
}

