/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.transform.TbAbstractTransformNode;
import org.thingsboard.rule.engine.transform.TbChangeOriginatorNodeConfiguration;
import org.thingsboard.rule.engine.util.EntitiesAlarmOriginatorIdAsyncLoader;
import org.thingsboard.rule.engine.util.EntitiesByNameAndTypeLoader;
import org.thingsboard.rule.engine.util.EntitiesCustomerIdAsyncLoader;
import org.thingsboard.rule.engine.util.EntitiesRelatedEntityIdAsyncLoader;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.TRANSFORMATION, name="change originator", configClazz=TbChangeOriginatorNodeConfiguration.class, nodeDescription="Change message originator to Tenant/Customer/Related Entity/Alarm Originator/Entity by name pattern.", nodeDetails="Configuration: <ul><li><strong>Customer</strong> - use customer of incoming message originator as new originator. Only for assigned to customer originators with one of the following type: 'User', 'Asset', 'Device'.</li><li><strong>Tenant</strong> - use current tenant as new originator.</li><li><strong>Related Entity</strong> - use related entity as new originator. Lookup based on configured relation query. If multiple related entities are found, only first entity is used as new originator, other entities are discarded.</li><li><strong>Alarm Originator</strong> - use alarm originator as new originator. Only if incoming message originator is alarm entity.</li><li><strong>Entity by name pattern</strong> - specify entity type and name pattern of new originator. Following entity types are supported: 'Device', 'Asset', 'Entity View', 'Edge' or 'User'.</li></ul>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeChangeOriginatorConfig", icon="find_replace")
public class TbChangeOriginatorNode
extends TbAbstractTransformNode<TbChangeOriginatorNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbChangeOriginatorNode.class);
    private static final String CUSTOMER_SOURCE = "CUSTOMER";
    private static final String TENANT_SOURCE = "TENANT";
    private static final String RELATED_SOURCE = "RELATED";
    private static final String ALARM_ORIGINATOR_SOURCE = "ALARM_ORIGINATOR";
    private static final String ENTITY_SOURCE = "ENTITY";

    @Override
    protected TbChangeOriginatorNodeConfiguration loadNodeConfiguration(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        TbChangeOriginatorNodeConfiguration config = (TbChangeOriginatorNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbChangeOriginatorNodeConfiguration.class);
        this.validateConfig(config);
        return config;
    }

    @Override
    protected ListenableFuture<List<TbMsg>> transform(TbContext ctx, TbMsg msg) {
        ListenableFuture<? extends EntityId> newOriginatorFuture = this.getNewOriginator(ctx, msg);
        return Futures.transformAsync(newOriginatorFuture, newOriginator -> {
            if (newOriginator == null || newOriginator.isNullUid()) {
                return Futures.immediateFailedFuture((Throwable)new NoSuchElementException("Failed to find new originator!"));
            }
            return Futures.immediateFuture(List.of(ctx.transformMsgOriginator(msg, newOriginator)));
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<? extends EntityId> getNewOriginator(TbContext ctx, TbMsg msg) {
        switch (((TbChangeOriginatorNodeConfiguration)this.config).getOriginatorSource()) {
            case "CUSTOMER": {
                return EntitiesCustomerIdAsyncLoader.findEntityIdAsync(ctx, msg.getOriginator());
            }
            case "TENANT": {
                return Futures.immediateFuture((Object)ctx.getTenantId());
            }
            case "RELATED": {
                return EntitiesRelatedEntityIdAsyncLoader.findEntityAsync(ctx, msg.getOriginator(), ((TbChangeOriginatorNodeConfiguration)this.config).getRelationsQuery());
            }
            case "ALARM_ORIGINATOR": {
                return EntitiesAlarmOriginatorIdAsyncLoader.findEntityIdAsync(ctx, msg.getOriginator());
            }
            case "ENTITY": {
                EntityType entityType = EntityType.valueOf((String)((TbChangeOriginatorNodeConfiguration)this.config).getEntityType());
                String entityName = TbNodeUtils.processPattern((String)((TbChangeOriginatorNodeConfiguration)this.config).getEntityNamePattern(), (TbMsg)msg);
                try {
                    EntityId targetEntity = EntitiesByNameAndTypeLoader.findEntityId(ctx, entityType, entityName);
                    return Futures.immediateFuture((Object)targetEntity);
                }
                catch (IllegalStateException e) {
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }
        }
        return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Unexpected originator source " + ((TbChangeOriginatorNodeConfiguration)this.config).getOriginatorSource()));
    }

    private void validateConfig(TbChangeOriginatorNodeConfiguration conf) {
        HashSet knownSources = Sets.newHashSet((Object[])new String[]{CUSTOMER_SOURCE, TENANT_SOURCE, RELATED_SOURCE, ALARM_ORIGINATOR_SOURCE, ENTITY_SOURCE});
        if (!knownSources.contains(conf.getOriginatorSource())) {
            log.error("Unsupported source [{}] for TbChangeOriginatorNode", (Object)conf.getOriginatorSource());
            throw new IllegalArgumentException("Unsupported source TbChangeOriginatorNode" + conf.getOriginatorSource());
        }
        if (conf.getOriginatorSource().equals(RELATED_SOURCE) && conf.getRelationsQuery() == null) {
            log.error("Related source for TbChangeOriginatorNode should have relations query. Actual [{}]", (Object)conf.getRelationsQuery());
            throw new IllegalArgumentException("Wrong config for RElated Source in TbChangeOriginatorNode" + conf.getOriginatorSource());
        }
        if (conf.getOriginatorSource().equals(ENTITY_SOURCE)) {
            if (conf.getEntityType() == null) {
                log.error("Entity type not specified for [{}]", (Object)ENTITY_SOURCE);
                throw new IllegalArgumentException("Wrong config for [{}] in TbChangeOriginatorNode!ENTITY");
            }
            if (StringUtils.isEmpty((String)conf.getEntityNamePattern())) {
                log.error("EntityNamePattern not specified for type [{}]", (Object)conf.getEntityType());
                throw new IllegalArgumentException("Wrong config for [{}] in TbChangeOriginatorNode!ENTITY");
            }
            EntitiesByNameAndTypeLoader.checkEntityType(EntityType.valueOf((String)conf.getEntityType()));
        }
    }
}

