/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.util.TbPair;

public abstract class TbAbstractTransformNodeWithTbMsgSource
implements TbNode {
    protected static final String FROM_METADATA_PROPERTY = "fromMetadata";

    protected abstract String getNewKeyForUpgradeFromVersionZero();

    protected abstract String getKeyToUpgradeFromVersionOne();

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        ObjectNode configToUpdate = (ObjectNode)oldConfiguration;
        switch (fromVersion) {
            case 0: {
                return this.upgradeToUseTbMsgSource(configToUpdate);
            }
            case 1: {
                return this.upgradeNodesWithVersionOneToUseTbMsgSource(configToUpdate);
            }
        }
        return new TbPair((Object)false, (Object)oldConfiguration);
    }

    private TbPair<Boolean, JsonNode> upgradeToUseTbMsgSource(ObjectNode configToUpdate) throws TbNodeException {
        if (!configToUpdate.has(FROM_METADATA_PROPERTY)) {
            throw new TbNodeException("property to update: 'fromMetadata' doesn't exists in configuration!");
        }
        String value = configToUpdate.get(FROM_METADATA_PROPERTY).asText();
        if ("true".equals(value)) {
            configToUpdate.remove(FROM_METADATA_PROPERTY);
            configToUpdate.put(this.getNewKeyForUpgradeFromVersionZero(), TbMsgSource.METADATA.name());
            return new TbPair((Object)true, (Object)configToUpdate);
        }
        if ("false".equals(value)) {
            configToUpdate.remove(FROM_METADATA_PROPERTY);
            configToUpdate.put(this.getNewKeyForUpgradeFromVersionZero(), TbMsgSource.DATA.name());
            return new TbPair((Object)true, (Object)configToUpdate);
        }
        throw new TbNodeException("property to update: 'fromMetadata' has unexpected value: " + value + ". Allowed values: true or false!");
    }

    private TbPair<Boolean, JsonNode> upgradeNodesWithVersionOneToUseTbMsgSource(ObjectNode configToUpdate) throws TbNodeException {
        if (configToUpdate.has(this.getNewKeyForUpgradeFromVersionZero())) {
            return new TbPair((Object)false, (Object)configToUpdate);
        }
        return this.upgradeTbMsgSourceKey(configToUpdate, this.getKeyToUpgradeFromVersionOne());
    }

    private TbPair<Boolean, JsonNode> upgradeTbMsgSourceKey(ObjectNode configToUpdate, String oldPropertyKey) throws TbNodeException {
        if (!configToUpdate.has(oldPropertyKey)) {
            throw new TbNodeException("property to update: '" + oldPropertyKey + "' doesn't exists in configuration!");
        }
        String value = configToUpdate.get(oldPropertyKey).asText();
        if (TbMsgSource.METADATA.name().equals(value)) {
            configToUpdate.remove(oldPropertyKey);
            configToUpdate.put(this.getNewKeyForUpgradeFromVersionZero(), TbMsgSource.METADATA.name());
            return new TbPair((Object)true, (Object)configToUpdate);
        }
        if (TbMsgSource.DATA.name().equals(value)) {
            configToUpdate.remove(oldPropertyKey);
            configToUpdate.put(this.getNewKeyForUpgradeFromVersionZero(), TbMsgSource.DATA.name());
            return new TbPair((Object)true, (Object)configToUpdate);
        }
        throw new TbNodeException("property to update: '" + oldPropertyKey + "' has unexpected value: " + value + ". Allowed values: true or false!");
    }
}

