/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.telemetry;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.telemetry.AttributesUpdateNodeCallback;
import org.thingsboard.rule.engine.telemetry.TbMsgAttributesNodeConfiguration;
import org.thingsboard.rule.engine.telemetry.TelemetryNodeCallback;
import org.thingsboard.server.common.adaptor.JsonConverter;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="save attributes", configClazz=TbMsgAttributesNodeConfiguration.class, version=2, nodeDescription="Saves attributes data", nodeDetails="Saves entity attributes based on configurable scope parameter. Expects messages with 'POST_ATTRIBUTES_REQUEST' message type. If upsert(update/insert) operation is completed successfully rule node will send the incoming message via <b>Success</b> chain, otherwise, <b>Failure</b> chain is used. Additionally if checkbox <b>Send attributes updated notification</b> is set to true, rule node will put the \"Attributes Updated\" event for <b>SHARED_SCOPE</b> and <b>SERVER_SCOPE</b> attributes updates to the corresponding rule engine queue.Performance checkbox 'Save attributes only if the value changes' will skip attributes overwrites for values with no changes (avoid concurrent writes because this check is not transactional; will not update 'Last updated time' for skipped attributes).", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeAttributesConfig", icon="file_upload")
public class TbMsgAttributesNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgAttributesNode.class);
    static final String NOTIFY_DEVICE_KEY = "notifyDevice";
    static final String SEND_ATTRIBUTES_UPDATED_NOTIFICATION_KEY = "sendAttributesUpdatedNotification";
    static final String UPDATE_ATTRIBUTES_ONLY_ON_VALUE_CHANGE_KEY = "updateAttributesOnlyOnValueChange";
    private TbMsgAttributesNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgAttributesNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgAttributesNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        if (!msg.isTypeOf(TbMsgType.POST_ATTRIBUTES_REQUEST)) {
            ctx.tellFailure(msg, (Throwable)new IllegalArgumentException("Unsupported msg type: " + msg.getType()));
            return;
        }
        String src = msg.getData();
        ArrayList<AttributeKvEntry> newAttributes = new ArrayList<AttributeKvEntry>(JsonConverter.convertToAttributes((JsonElement)JsonParser.parseString((String)src)));
        if (newAttributes.isEmpty()) {
            ctx.tellSuccess(msg);
            return;
        }
        String scope = this.getScope(msg.getMetaData().getValue("scope"));
        boolean sendAttributesUpdateNotification = this.checkSendNotification(scope);
        if (!this.config.isUpdateAttributesOnlyOnValueChange()) {
            this.saveAttr(newAttributes, ctx, msg, scope, sendAttributesUpdateNotification);
            return;
        }
        List keys = newAttributes.stream().map(KvEntry::getKey).collect(Collectors.toList());
        ListenableFuture findFuture = ctx.getAttributesService().find(ctx.getTenantId(), msg.getOriginator(), scope, keys);
        DonAsynchron.withCallback((ListenableFuture)findFuture, currentAttributes -> {
            List<AttributeKvEntry> attributesChanged = this.filterChangedAttr((List<AttributeKvEntry>)currentAttributes, (List<AttributeKvEntry>)newAttributes);
            this.saveAttr(attributesChanged, ctx, msg, scope, sendAttributesUpdateNotification);
        }, throwable -> ctx.tellFailure(msg, throwable), (Executor)MoreExecutors.directExecutor());
    }

    void saveAttr(List<AttributeKvEntry> attributes, TbContext ctx, TbMsg msg, String scope, boolean sendAttributesUpdateNotification) {
        if (attributes.isEmpty()) {
            ctx.tellSuccess(msg);
            return;
        }
        ctx.getTelemetryService().saveAndNotify(ctx.getTenantId(), msg.getOriginator(), scope, attributes, this.config.isNotifyDevice() || this.checkNotifyDeviceMdValue(msg.getMetaData().getValue(NOTIFY_DEVICE_KEY)), (FutureCallback)(sendAttributesUpdateNotification ? new AttributesUpdateNodeCallback(ctx, msg, scope, attributes) : new TelemetryNodeCallback(ctx, msg)));
    }

    List<AttributeKvEntry> filterChangedAttr(List<AttributeKvEntry> currentAttributes, List<AttributeKvEntry> newAttributes) {
        if (currentAttributes == null || currentAttributes.isEmpty()) {
            return newAttributes;
        }
        Map currentAttrMap = currentAttributes.stream().collect(Collectors.toMap(KvEntry::getKey, Function.identity(), (existing, replacement) -> existing));
        return newAttributes.stream().filter(item -> {
            AttributeKvEntry cacheAttr = (AttributeKvEntry)currentAttrMap.get(item.getKey());
            return cacheAttr == null || !Objects.equals(item.getValue(), cacheAttr.getValue()) || !Objects.equals(item.getDataType(), cacheAttr.getDataType());
        }).collect(Collectors.toList());
    }

    private boolean checkSendNotification(String scope) {
        return this.config.isSendAttributesUpdatedNotification() && !"CLIENT_SCOPE".equals(scope);
    }

    private boolean checkNotifyDeviceMdValue(String notifyDeviceMdValue) {
        return StringUtils.isEmpty((String)notifyDeviceMdValue) || Boolean.parseBoolean(notifyDeviceMdValue);
    }

    private String getScope(String mdScopeValue) {
        if (StringUtils.isNotEmpty((String)mdScopeValue)) {
            return mdScopeValue;
        }
        return this.config.getScope();
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        boolean hasChanges = false;
        switch (fromVersion) {
            case 0: {
                if (!oldConfiguration.has(UPDATE_ATTRIBUTES_ONLY_ON_VALUE_CHANGE_KEY)) {
                    hasChanges = true;
                    ((ObjectNode)oldConfiguration).put(UPDATE_ATTRIBUTES_ONLY_ON_VALUE_CHANGE_KEY, false);
                }
            }
            case 1: {
                hasChanges = this.fixEscapedBooleanConfigParameter(oldConfiguration, NOTIFY_DEVICE_KEY, hasChanges, true);
                hasChanges = this.fixEscapedBooleanConfigParameter(oldConfiguration, SEND_ATTRIBUTES_UPDATED_NOTIFICATION_KEY, hasChanges, false);
                hasChanges = this.fixEscapedBooleanConfigParameter(oldConfiguration, UPDATE_ATTRIBUTES_ONLY_ON_VALUE_CHANGE_KEY, hasChanges, true);
                break;
            }
        }
        return new TbPair((Object)hasChanges, (Object)oldConfiguration);
    }

    private boolean fixEscapedBooleanConfigParameter(JsonNode oldConfiguration, String boolKey, boolean hasChanges, boolean valueIfNull) {
        if (oldConfiguration.hasNonNull(boolKey)) {
            JsonNode value = oldConfiguration.get(boolKey);
            if (value.isTextual()) {
                hasChanges = true;
                ((ObjectNode)oldConfiguration).put(boolKey, value.asBoolean(valueIfNull));
            }
        } else {
            hasChanges = true;
            ((ObjectNode)oldConfiguration).put(boolKey, valueIfNull);
        }
        return hasChanges;
    }
}

