/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.rpc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.rpc.TbSendRpcReplyNodeConfiguration;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ACTION, name="rpc call reply", configClazz=TbSendRpcReplyNodeConfiguration.class, nodeDescription="Sends reply to RPC call from device", nodeDetails="Expects messages with any message type. Will forward message body to the device.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbActionNodeRpcReplyConfig", icon="call_merge")
public class TbSendRPCReplyNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbSendRPCReplyNode.class);
    private TbSendRpcReplyNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbSendRpcReplyNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbSendRpcReplyNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        String serviceIdStr = msg.getMetaData().getValue(this.config.getServiceIdMetaDataAttribute());
        String sessionIdStr = msg.getMetaData().getValue(this.config.getSessionIdMetaDataAttribute());
        String requestIdStr = msg.getMetaData().getValue(this.config.getRequestIdMetaDataAttribute());
        if (msg.getOriginator().getEntityType() != EntityType.DEVICE) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Message originator is not a device entity!"));
        } else if (StringUtils.isEmpty((String)requestIdStr)) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Request id is not present in the metadata!"));
        } else if (StringUtils.isEmpty((String)serviceIdStr)) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Service id is not present in the metadata!"));
        } else if (StringUtils.isEmpty((String)sessionIdStr)) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Session id is not present in the metadata!"));
        } else if (StringUtils.isEmpty((String)msg.getData())) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Request body is empty!"));
        } else if (StringUtils.isNotBlank((String)msg.getMetaData().getValue("edgeId"))) {
            this.saveRpcResponseToEdgeQueue(ctx, msg, serviceIdStr, sessionIdStr, requestIdStr);
        } else {
            ctx.getRpcService().sendRpcReplyToDevice(serviceIdStr, UUID.fromString(sessionIdStr), Integer.parseInt(requestIdStr), msg.getData());
            ctx.tellSuccess(msg);
        }
    }

    private void saveRpcResponseToEdgeQueue(final TbContext ctx, final TbMsg msg, String serviceIdStr, String sessionIdStr, String requestIdStr) {
        DeviceId deviceId;
        EdgeId edgeId;
        try {
            edgeId = new EdgeId(UUID.fromString(msg.getMetaData().getValue("edgeId")));
            deviceId = new DeviceId(UUID.fromString(msg.getMetaData().getValue("deviceId")));
        }
        catch (Exception e) {
            String errMsg = String.format("[%s] Failed to parse edgeId or deviceId from metadata %s!", ctx.getTenantId(), msg.getMetaData());
            ctx.tellFailure(msg, (Throwable)new RuntimeException(errMsg));
            return;
        }
        ObjectNode body = JacksonUtil.newObjectNode();
        body.put("serviceId", serviceIdStr);
        body.put("sessionId", sessionIdStr);
        body.put("requestId", requestIdStr);
        body.put("response", msg.getData());
        EdgeEvent edgeEvent = EdgeUtils.constructEdgeEvent((TenantId)ctx.getTenantId(), (EdgeId)edgeId, (EdgeEventType)EdgeEventType.DEVICE, (EdgeEventActionType)EdgeEventActionType.RPC_CALL, (EntityId)deviceId, (JsonNode)JacksonUtil.valueToTree((Object)body));
        ListenableFuture future = ctx.getEdgeEventService().saveAsync(edgeEvent);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                ctx.onEdgeEventUpdate(ctx.getTenantId(), edgeId);
                ctx.tellSuccess(msg);
            }

            public void onFailure(Throwable t) {
                ctx.tellFailure(msg, t);
            }
        }, (Executor)ctx.getDbCallbackExecutor());
    }
}

