/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.rest;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collections;
import java.util.Map;
import org.thingsboard.rule.engine.api.NodeConfiguration;
import org.thingsboard.rule.engine.credentials.AnonymousCredentials;
import org.thingsboard.rule.engine.credentials.ClientCredentials;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TbRestApiCallNodeConfiguration
implements NodeConfiguration<TbRestApiCallNodeConfiguration> {
    private String restEndpointUrlPattern;
    private String requestMethod;
    private Map<String, String> headers;
    private boolean useSimpleClientHttpFactory;
    private int readTimeoutMs;
    private int maxParallelRequestsCount;
    private boolean useRedisQueueForMsgPersistence;
    private boolean parseToPlainText;
    private boolean enableProxy;
    private boolean useSystemProxyProperties;
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String proxyScheme;
    private ClientCredentials credentials;
    private boolean ignoreRequestBody;

    public TbRestApiCallNodeConfiguration defaultConfiguration() {
        TbRestApiCallNodeConfiguration configuration = new TbRestApiCallNodeConfiguration();
        configuration.setRestEndpointUrlPattern("http://localhost/api");
        configuration.setRequestMethod("POST");
        configuration.setHeaders(Collections.singletonMap("Content-Type", "application/json"));
        configuration.setUseSimpleClientHttpFactory(false);
        configuration.setReadTimeoutMs(0);
        configuration.setMaxParallelRequestsCount(0);
        configuration.setUseRedisQueueForMsgPersistence(false);
        configuration.setParseToPlainText(false);
        configuration.setEnableProxy(false);
        configuration.setCredentials(new AnonymousCredentials());
        configuration.setIgnoreRequestBody(false);
        return configuration;
    }

    public ClientCredentials getCredentials() {
        if (this.credentials == null) {
            return new AnonymousCredentials();
        }
        return this.credentials;
    }

    public String getRestEndpointUrlPattern() {
        return this.restEndpointUrlPattern;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isUseSimpleClientHttpFactory() {
        return this.useSimpleClientHttpFactory;
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public int getMaxParallelRequestsCount() {
        return this.maxParallelRequestsCount;
    }

    public boolean isUseRedisQueueForMsgPersistence() {
        return this.useRedisQueueForMsgPersistence;
    }

    public boolean isParseToPlainText() {
        return this.parseToPlainText;
    }

    public boolean isEnableProxy() {
        return this.enableProxy;
    }

    public boolean isUseSystemProxyProperties() {
        return this.useSystemProxyProperties;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public boolean isIgnoreRequestBody() {
        return this.ignoreRequestBody;
    }

    public void setRestEndpointUrlPattern(String restEndpointUrlPattern) {
        this.restEndpointUrlPattern = restEndpointUrlPattern;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setUseSimpleClientHttpFactory(boolean useSimpleClientHttpFactory) {
        this.useSimpleClientHttpFactory = useSimpleClientHttpFactory;
    }

    public void setReadTimeoutMs(int readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
    }

    public void setMaxParallelRequestsCount(int maxParallelRequestsCount) {
        this.maxParallelRequestsCount = maxParallelRequestsCount;
    }

    public void setUseRedisQueueForMsgPersistence(boolean useRedisQueueForMsgPersistence) {
        this.useRedisQueueForMsgPersistence = useRedisQueueForMsgPersistence;
    }

    public void setParseToPlainText(boolean parseToPlainText) {
        this.parseToPlainText = parseToPlainText;
    }

    public void setEnableProxy(boolean enableProxy) {
        this.enableProxy = enableProxy;
    }

    public void setUseSystemProxyProperties(boolean useSystemProxyProperties) {
        this.useSystemProxyProperties = useSystemProxyProperties;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setProxyScheme(String proxyScheme) {
        this.proxyScheme = proxyScheme;
    }

    public void setCredentials(ClientCredentials credentials) {
        this.credentials = credentials;
    }

    public void setIgnoreRequestBody(boolean ignoreRequestBody) {
        this.ignoreRequestBody = ignoreRequestBody;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbRestApiCallNodeConfiguration)) {
            return false;
        }
        TbRestApiCallNodeConfiguration other = (TbRestApiCallNodeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseSimpleClientHttpFactory() != other.isUseSimpleClientHttpFactory()) {
            return false;
        }
        if (this.getReadTimeoutMs() != other.getReadTimeoutMs()) {
            return false;
        }
        if (this.getMaxParallelRequestsCount() != other.getMaxParallelRequestsCount()) {
            return false;
        }
        if (this.isUseRedisQueueForMsgPersistence() != other.isUseRedisQueueForMsgPersistence()) {
            return false;
        }
        if (this.isParseToPlainText() != other.isParseToPlainText()) {
            return false;
        }
        if (this.isEnableProxy() != other.isEnableProxy()) {
            return false;
        }
        if (this.isUseSystemProxyProperties() != other.isUseSystemProxyProperties()) {
            return false;
        }
        if (this.getProxyPort() != other.getProxyPort()) {
            return false;
        }
        if (this.isIgnoreRequestBody() != other.isIgnoreRequestBody()) {
            return false;
        }
        String this$restEndpointUrlPattern = this.getRestEndpointUrlPattern();
        String other$restEndpointUrlPattern = other.getRestEndpointUrlPattern();
        if (this$restEndpointUrlPattern == null ? other$restEndpointUrlPattern != null : !this$restEndpointUrlPattern.equals(other$restEndpointUrlPattern)) {
            return false;
        }
        String this$requestMethod = this.getRequestMethod();
        String other$requestMethod = other.getRequestMethod();
        if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        String this$proxyUser = this.getProxyUser();
        String other$proxyUser = other.getProxyUser();
        if (this$proxyUser == null ? other$proxyUser != null : !this$proxyUser.equals(other$proxyUser)) {
            return false;
        }
        String this$proxyPassword = this.getProxyPassword();
        String other$proxyPassword = other.getProxyPassword();
        if (this$proxyPassword == null ? other$proxyPassword != null : !this$proxyPassword.equals(other$proxyPassword)) {
            return false;
        }
        String this$proxyScheme = this.getProxyScheme();
        String other$proxyScheme = other.getProxyScheme();
        if (this$proxyScheme == null ? other$proxyScheme != null : !this$proxyScheme.equals(other$proxyScheme)) {
            return false;
        }
        ClientCredentials this$credentials = this.getCredentials();
        ClientCredentials other$credentials = other.getCredentials();
        return !(this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbRestApiCallNodeConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSimpleClientHttpFactory() ? 79 : 97);
        result = result * 59 + this.getReadTimeoutMs();
        result = result * 59 + this.getMaxParallelRequestsCount();
        result = result * 59 + (this.isUseRedisQueueForMsgPersistence() ? 79 : 97);
        result = result * 59 + (this.isParseToPlainText() ? 79 : 97);
        result = result * 59 + (this.isEnableProxy() ? 79 : 97);
        result = result * 59 + (this.isUseSystemProxyProperties() ? 79 : 97);
        result = result * 59 + this.getProxyPort();
        result = result * 59 + (this.isIgnoreRequestBody() ? 79 : 97);
        String $restEndpointUrlPattern = this.getRestEndpointUrlPattern();
        result = result * 59 + ($restEndpointUrlPattern == null ? 43 : $restEndpointUrlPattern.hashCode());
        String $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        String $proxyUser = this.getProxyUser();
        result = result * 59 + ($proxyUser == null ? 43 : $proxyUser.hashCode());
        String $proxyPassword = this.getProxyPassword();
        result = result * 59 + ($proxyPassword == null ? 43 : $proxyPassword.hashCode());
        String $proxyScheme = this.getProxyScheme();
        result = result * 59 + ($proxyScheme == null ? 43 : $proxyScheme.hashCode());
        ClientCredentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        return result;
    }

    public String toString() {
        return "TbRestApiCallNodeConfiguration(restEndpointUrlPattern=" + this.getRestEndpointUrlPattern() + ", requestMethod=" + this.getRequestMethod() + ", headers=" + this.getHeaders() + ", useSimpleClientHttpFactory=" + this.isUseSimpleClientHttpFactory() + ", readTimeoutMs=" + this.getReadTimeoutMs() + ", maxParallelRequestsCount=" + this.getMaxParallelRequestsCount() + ", useRedisQueueForMsgPersistence=" + this.isUseRedisQueueForMsgPersistence() + ", parseToPlainText=" + this.isParseToPlainText() + ", enableProxy=" + this.isEnableProxy() + ", useSystemProxyProperties=" + this.isUseSystemProxyProperties() + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", proxyUser=" + this.getProxyUser() + ", proxyPassword=" + this.getProxyPassword() + ", proxyScheme=" + this.getProxyScheme() + ", credentials=" + this.getCredentials() + ", ignoreRequestBody=" + this.isIgnoreRequestBody() + ")";
    }
}

