/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.profile;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleEngineDeviceProfileCache;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.profile.DeviceState;
import org.thingsboard.rule.engine.profile.ProfileState;
import org.thingsboard.rule.engine.profile.TbDeviceProfileNodeConfiguration;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.rule.RuleNodeState;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;

@RuleNode(type=ComponentType.ACTION, name="device profile", customRelations=true, relationTypes={"Alarm Created", "Alarm Updated", "Alarm Severity Updated", "Alarm Cleared", "Success", "Failure"}, configClazz=TbDeviceProfileNodeConfiguration.class, nodeDescription="Process device messages based on device profile settings", nodeDetails="Create and clear alarms based on alarm rules defined in device profile. The output relation type is either 'Alarm Created', 'Alarm Updated', 'Alarm Severity Updated' and 'Alarm Cleared' or simply 'Success' if no alarms were affected.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbDeviceProfileConfig")
public class TbDeviceProfileNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbDeviceProfileNode.class);
    private TbDeviceProfileNodeConfiguration config;
    private RuleEngineDeviceProfileCache cache;
    private TbContext ctx;
    private final Map<DeviceId, DeviceState> deviceStates = new ConcurrentHashMap<DeviceId, DeviceState>();

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbDeviceProfileNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbDeviceProfileNodeConfiguration.class);
        this.cache = ctx.getDeviceProfileCache();
        this.ctx = ctx;
        this.scheduleAlarmHarvesting(ctx, null);
        ctx.addDeviceProfileListeners(this::onProfileUpdate, this::onDeviceUpdate);
        this.initAlarmRuleState(false);
    }

    private void initAlarmRuleState(boolean printNewlyAddedDeviceStates) {
        if (this.config.isFetchAlarmRulesStateOnStart()) {
            log.info("[{}] Fetching alarm rule state", (Object)this.ctx.getSelfId());
            int fetchCount = 0;
            PageLink pageLink = new PageLink(1024);
            while (true) {
                PageData states;
                if (!(states = this.ctx.findRuleNodeStates(pageLink)).getData().isEmpty()) {
                    for (RuleNodeState rns : states.getData()) {
                        ++fetchCount;
                        if (!rns.getEntityId().getEntityType().equals((Object)EntityType.DEVICE) || !this.ctx.isLocalEntity(rns.getEntityId())) continue;
                        this.getOrCreateDeviceState(this.ctx, new DeviceId(rns.getEntityId().getId()), rns, printNewlyAddedDeviceStates);
                    }
                }
                if (!states.hasNext()) break;
                pageLink = pageLink.nextPageLink();
            }
            log.info("[{}] Fetched alarm rule state for {} entities", (Object)this.ctx.getSelfId(), (Object)fetchCount);
        }
        if (!this.config.isPersistAlarmRulesState() && this.ctx.isLocalEntity((EntityId)this.ctx.getSelfId())) {
            log.debug("[{}] Going to cleanup rule node states", (Object)this.ctx.getSelfId());
            this.ctx.clearRuleNodeStates();
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException {
        EntityType originatorType = msg.getOriginator().getEntityType();
        if (msg.isTypeOf(TbMsgType.DEVICE_PROFILE_PERIODIC_SELF_MSG)) {
            this.scheduleAlarmHarvesting(ctx, msg);
            this.harvestAlarms(ctx, System.currentTimeMillis());
        } else if (msg.isTypeOf(TbMsgType.DEVICE_PROFILE_UPDATE_SELF_MSG)) {
            this.updateProfile(ctx, new DeviceProfileId(UUID.fromString(msg.getData())));
        } else if (msg.isTypeOf(TbMsgType.DEVICE_UPDATE_SELF_MSG)) {
            JsonNode data = JacksonUtil.toJsonNode((String)msg.getData());
            DeviceId deviceId = new DeviceId(UUID.fromString(data.get("deviceId").asText()));
            if (data.has("profileId")) {
                this.invalidateDeviceProfileCache(deviceId, new DeviceProfileId(UUID.fromString(data.get("deviceProfileId").asText())));
            } else {
                this.removeDeviceState(deviceId);
            }
        } else if (EntityType.DEVICE.equals((Object)originatorType)) {
            DeviceId deviceId = new DeviceId(msg.getOriginator().getId());
            if (msg.isTypeOf(TbMsgType.ENTITY_UPDATED)) {
                this.invalidateDeviceProfileCache(deviceId, msg.getData());
                ctx.tellSuccess(msg);
            } else if (msg.isTypeOf(TbMsgType.ENTITY_DELETED)) {
                this.removeDeviceState(deviceId);
                ctx.tellSuccess(msg);
            } else {
                DeviceState deviceState = this.getOrCreateDeviceState(ctx, deviceId, null, false);
                if (deviceState != null) {
                    deviceState.process(ctx, msg);
                } else {
                    log.info("Device was not found! Most probably device [" + deviceId + "] has been removed from the database. Acknowledging msg.");
                    ctx.ack(msg);
                }
            }
        } else {
            ctx.tellSuccess(msg);
        }
    }

    public void onPartitionChangeMsg(TbContext ctx, PartitionChangeMsg msg) {
        this.deviceStates.entrySet().removeIf(entry -> !ctx.isLocalEntity((EntityId)entry.getKey()));
        this.initAlarmRuleState(true);
    }

    public void destroy() {
        this.ctx.removeListeners();
        this.deviceStates.clear();
    }

    protected DeviceState getOrCreateDeviceState(TbContext ctx, DeviceId deviceId, RuleNodeState rns, boolean printNewlyAddedDeviceStates) {
        DeviceProfile deviceProfile;
        DeviceState deviceState = this.deviceStates.get(deviceId);
        if (deviceState == null && (deviceProfile = this.cache.get(ctx.getTenantId(), deviceId)) != null) {
            deviceState = new DeviceState(ctx, this.config, deviceId, new ProfileState(deviceProfile), rns);
            this.deviceStates.put(deviceId, deviceState);
            if (printNewlyAddedDeviceStates) {
                log.info("[{}][{}] Device [{}] was added during PartitionChangeMsg", new Object[]{ctx.getTenantId(), ctx.getSelfId(), deviceId});
            }
        }
        return deviceState;
    }

    protected void scheduleAlarmHarvesting(TbContext ctx, TbMsg msg) {
        TbMsg periodicCheck = TbMsg.newMsg((TbMsgType)TbMsgType.DEVICE_PROFILE_PERIODIC_SELF_MSG, (EntityId)ctx.getTenantId(), (CustomerId)(msg != null ? msg.getCustomerId() : null), (TbMsgMetaData)TbMsgMetaData.EMPTY, (String)"{}");
        ctx.tellSelf(periodicCheck, TimeUnit.MINUTES.toMillis(1L));
    }

    protected void harvestAlarms(TbContext ctx, long ts) throws ExecutionException, InterruptedException {
        for (DeviceState state : this.deviceStates.values()) {
            state.harvestAlarms(ctx, ts);
        }
    }

    protected void updateProfile(TbContext ctx, DeviceProfileId deviceProfileId) throws ExecutionException, InterruptedException {
        DeviceProfile deviceProfile = this.cache.get(ctx.getTenantId(), deviceProfileId);
        if (deviceProfile != null) {
            log.debug("[{}] Received device profile update notification: {}", (Object)ctx.getSelfId(), (Object)deviceProfile);
            for (DeviceState state : this.deviceStates.values()) {
                if (!deviceProfile.getId().equals((Object)state.getProfileId())) continue;
                state.updateProfile(ctx, deviceProfile);
            }
        } else {
            log.debug("[{}] Received stale profile update notification: [{}]", (Object)ctx.getSelfId(), (Object)deviceProfileId);
        }
    }

    protected void onProfileUpdate(DeviceProfile profile) {
        this.ctx.tellSelf(TbMsg.newMsg((TbMsgType)TbMsgType.DEVICE_PROFILE_UPDATE_SELF_MSG, (EntityId)this.ctx.getTenantId(), (TbMsgMetaData)TbMsgMetaData.EMPTY, (String)profile.getId().getId().toString()), 0L);
    }

    private void onDeviceUpdate(DeviceId deviceId, DeviceProfile deviceProfile) {
        ObjectNode msgData = JacksonUtil.newObjectNode();
        msgData.put("deviceId", deviceId.getId().toString());
        if (deviceProfile != null) {
            msgData.put("deviceProfileId", deviceProfile.getId().getId().toString());
        }
        this.ctx.tellSelf(TbMsg.newMsg((TbMsgType)TbMsgType.DEVICE_UPDATE_SELF_MSG, (EntityId)this.ctx.getTenantId(), (TbMsgMetaData)TbMsgMetaData.EMPTY, (String)JacksonUtil.toString((Object)msgData)), 0L);
    }

    protected void invalidateDeviceProfileCache(DeviceId deviceId, String deviceJson) {
        DeviceState deviceState = this.deviceStates.get(deviceId);
        if (deviceState != null) {
            DeviceProfileId currentProfileId = deviceState.getProfileId();
            try {
                Device device = (Device)JacksonUtil.fromString((String)deviceJson, Device.class);
                if (!currentProfileId.equals((Object)device.getDeviceProfileId())) {
                    this.removeDeviceState(deviceId);
                }
            }
            catch (IllegalArgumentException e) {
                log.debug("[{}] Received device update notification with non-device msg body: [{}]", new Object[]{this.ctx.getSelfId(), deviceId, e});
            }
        }
    }

    protected void invalidateDeviceProfileCache(DeviceId deviceId, DeviceProfileId deviceProfileId) {
        DeviceState deviceState = this.deviceStates.get(deviceId);
        if (deviceState != null && !deviceState.getProfileId().equals((Object)deviceProfileId)) {
            this.removeDeviceState(deviceId);
        }
    }

    private void removeDeviceState(DeviceId deviceId) {
        DeviceState state = this.deviceStates.remove(deviceId);
        if (this.config.isPersistAlarmRulesState() && (state != null || !this.config.isFetchAlarmRulesStateOnStart())) {
            this.ctx.removeRuleNodeStateForEntity((EntityId)deviceId);
        }
    }
}

