/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.notification;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.thingsboard.rule.engine.api.NodeConfiguration;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversation;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversationType;

public class TbSlackNodeConfiguration
implements NodeConfiguration<TbSlackNodeConfiguration> {
    private String botToken;
    private boolean useSystemSettings;
    @NotEmpty
    private String messageTemplate;
    private SlackConversationType conversationType;
    @NotNull
    @Valid
    private SlackConversation conversation;

    public TbSlackNodeConfiguration defaultConfiguration() {
        TbSlackNodeConfiguration config = new TbSlackNodeConfiguration();
        config.setUseSystemSettings(true);
        config.setBotToken("xoxb-");
        config.setMessageTemplate("Device ${deviceId}: temperature is $[temperature]");
        config.setConversationType(SlackConversationType.PUBLIC_CHANNEL);
        return config;
    }

    public String getBotToken() {
        return this.botToken;
    }

    public boolean isUseSystemSettings() {
        return this.useSystemSettings;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public SlackConversationType getConversationType() {
        return this.conversationType;
    }

    public SlackConversation getConversation() {
        return this.conversation;
    }

    public void setBotToken(String botToken) {
        this.botToken = botToken;
    }

    public void setUseSystemSettings(boolean useSystemSettings) {
        this.useSystemSettings = useSystemSettings;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public void setConversationType(SlackConversationType conversationType) {
        this.conversationType = conversationType;
    }

    public void setConversation(SlackConversation conversation) {
        this.conversation = conversation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbSlackNodeConfiguration)) {
            return false;
        }
        TbSlackNodeConfiguration other = (TbSlackNodeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseSystemSettings() != other.isUseSystemSettings()) {
            return false;
        }
        String this$botToken = this.getBotToken();
        String other$botToken = other.getBotToken();
        if (this$botToken == null ? other$botToken != null : !this$botToken.equals(other$botToken)) {
            return false;
        }
        String this$messageTemplate = this.getMessageTemplate();
        String other$messageTemplate = other.getMessageTemplate();
        if (this$messageTemplate == null ? other$messageTemplate != null : !this$messageTemplate.equals(other$messageTemplate)) {
            return false;
        }
        SlackConversationType this$conversationType = this.getConversationType();
        SlackConversationType other$conversationType = other.getConversationType();
        if (this$conversationType == null ? other$conversationType != null : !this$conversationType.equals(other$conversationType)) {
            return false;
        }
        SlackConversation this$conversation = this.getConversation();
        SlackConversation other$conversation = other.getConversation();
        return !(this$conversation == null ? other$conversation != null : !this$conversation.equals(other$conversation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbSlackNodeConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseSystemSettings() ? 79 : 97);
        String $botToken = this.getBotToken();
        result = result * 59 + ($botToken == null ? 43 : $botToken.hashCode());
        String $messageTemplate = this.getMessageTemplate();
        result = result * 59 + ($messageTemplate == null ? 43 : $messageTemplate.hashCode());
        SlackConversationType $conversationType = this.getConversationType();
        result = result * 59 + ($conversationType == null ? 43 : $conversationType.hashCode());
        SlackConversation $conversation = this.getConversation();
        result = result * 59 + ($conversation == null ? 43 : $conversation.hashCode());
        return result;
    }

    public String toString() {
        return "TbSlackNodeConfiguration(botToken=" + this.getBotToken() + ", useSystemSettings=" + this.isUseSystemSettings() + ", messageTemplate=" + this.getMessageTemplate() + ", conversationType=" + this.getConversationType() + ", conversation=" + this.getConversation() + ")";
    }
}

