/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.notification;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.external.TbAbstractExternalNode;
import org.thingsboard.rule.engine.notification.TbSlackNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.EXTERNAL, name="send to slack", configClazz=TbSlackNodeConfiguration.class, nodeDescription="Send message via Slack", nodeDetails="Sends message to a Slack channel or user", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbExternalNodeSlackConfig", iconUrl="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZD0iTTYsMTVBMiwyIDAgMCwxIDQsMTdBMiwyIDAgMCwxIDIsMTVBMiwyIDAgMCwxIDQsMTNINlYxNU03LDE1QTIsMiAwIDAsMSA5LDEzQTIsMiAwIDAsMSAxMSwxNVYyMEEyLDIgMCAwLDEgOSwyMkEyLDIgMCAwLDEgNywyMFYxNU05LDdBMiwyIDAgMCwxIDcsNUEyLDIgMCAwLDEgOSwzQTIsMiAwIDAsMSAxMSw1VjdIOU05LDhBMiwyIDAgMCwxIDExLDEwQTIsMiAwIDAsMSA5LDEySDRBMiwyIDAgMCwxIDIsMTBBMiwyIDAgMCwxIDQsOEg5TTE3LDEwQTIsMiAwIDAsMSAxOSw4QTIsMiAwIDAsMSAyMSwxMEEyLDIgMCAwLDEgMTksMTJIMTdWMTBNMTYsMTBBMiwyIDAgMCwxIDE0LDEyQTIsMiAwIDAsMSAxMiwxMFY1QTIsMiAwIDAsMSAxNCwzQTIsMiAwIDAsMSAxNiw1VjEwTTE0LDE4QTIsMiAwIDAsMSAxNiwyMEEyLDIgMCAwLDEgMTQsMjJBMiwyIDAgMCwxIDEyLDIwVjE4SDE0TTE0LDE3QTIsMiAwIDAsMSAxMiwxNUEyLDIgMCAwLDEgMTQsMTNIMTlBMiwyIDAgMCwxIDIxLDE1QTIsMiAwIDAsMSAxOSwxN0gxNFoiIC8+PC9zdmc+")
public class TbSlackNode
extends TbAbstractExternalNode {
    private TbSlackNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        super.init(ctx);
        this.config = (TbSlackNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbSlackNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        String token = this.config.isUseSystemSettings() ? ctx.getSlackService().getToken(ctx.getTenantId()) : this.config.getBotToken();
        if (token == null) {
            throw new IllegalArgumentException("Slack token is missing");
        }
        String message = TbNodeUtils.processPattern((String)this.config.getMessageTemplate(), (TbMsg)msg);
        TbMsg tbMsg = this.ackIfNeeded(ctx, msg);
        DonAsynchron.withCallback((ListenableFuture)ctx.getExternalCallExecutor().executeAsync(() -> ctx.getSlackService().sendMessage(ctx.getTenantId(), token, this.config.getConversation().getId(), message)), r -> this.tellSuccess(ctx, tbMsg), e -> this.tellFailure(ctx, tbMsg, (Throwable)e));
    }
}

