/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.notification;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.external.TbAbstractExternalNode;
import org.thingsboard.rule.engine.notification.TbNotificationNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestConfig;
import org.thingsboard.server.common.data.notification.NotificationRequestStats;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleEngineOriginatedNotificationInfo;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.EXTERNAL, name="send notification", configClazz=TbNotificationNodeConfiguration.class, nodeDescription="Sends notification to targets using the template", nodeDetails="Will send notification to the specified targets using the template", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbExternalNodeNotificationConfig", icon="notifications")
public class TbNotificationNode
extends TbAbstractExternalNode {
    private TbNotificationNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        super.init(ctx);
        this.config = (TbNotificationNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbNotificationNodeConfiguration.class);
    }

    public void onMsg(final TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        RuleEngineOriginatedNotificationInfo notificationInfo = RuleEngineOriginatedNotificationInfo.builder().msgOriginator(msg.getOriginator()).msgCustomerId((CustomerId)(msg.getOriginator().getEntityType() == EntityType.CUSTOMER && msg.getOriginator().equals(msg.getCustomerId()) ? null : msg.getCustomerId())).msgMetadata(msg.getMetaData().getData()).msgData(JacksonUtil.toFlatMap((JsonNode)JacksonUtil.toJsonNode((String)msg.getData()))).msgType(msg.getType()).build();
        NotificationRequest notificationRequest = NotificationRequest.builder().tenantId(ctx.getTenantId()).targets(this.config.getTargets()).templateId(this.config.getTemplateId()).info((NotificationInfo)notificationInfo).additionalConfig(new NotificationRequestConfig()).originatorEntityId((EntityId)ctx.getSelf().getRuleChainId()).build();
        final TbMsg tbMsg = this.ackIfNeeded(ctx, msg);
        FutureCallback<NotificationRequestStats> callback = new FutureCallback<NotificationRequestStats>(){

            public void onSuccess(NotificationRequestStats stats) {
                TbMsgMetaData metaData = tbMsg.getMetaData().copy();
                metaData.putValue("notificationRequestResult", JacksonUtil.toString((Object)stats));
                TbNotificationNode.this.tellSuccess(ctx, TbMsg.transformMsgMetadata((TbMsg)tbMsg, (TbMsgMetaData)metaData));
            }

            public void onFailure(Throwable e) {
                TbNotificationNode.this.tellFailure(ctx, tbMsg, e);
            }
        };
        ListenableFuture future = ctx.getNotificationExecutor().executeAsync(() -> TbNotificationNode.lambda$onMsg$0(ctx, notificationRequest, callback));
        DonAsynchron.withCallback((ListenableFuture)future, r -> {}, (callback)::onFailure);
    }

    private static /* synthetic */ NotificationRequest lambda$onMsg$0(TbContext ctx, NotificationRequest notificationRequest, 1 callback) throws Exception {
        return ctx.getNotificationCenter().processNotificationRequest(ctx.getTenantId(), notificationRequest, (FutureCallback)callback);
    }
}

