/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListenableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDetailsNode;
import org.thingsboard.rule.engine.metadata.TbGetTenantDetailsNodeConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="tenant details", configClazz=TbGetTenantDetailsNodeConfiguration.class, version=1, nodeDescription="Adds message originator tenant details into message or message metadata", nodeDetails="Useful when we need to retrieve contact information from your tenant such as email, phone, address, etc., for notifications via email, SMS, and other notification providers.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeEntityDetailsConfig")
public class TbGetTenantDetailsNode
extends TbAbstractGetEntityDetailsNode<TbGetTenantDetailsNodeConfiguration, TenantId> {
    private static final Logger log = LoggerFactory.getLogger(TbGetTenantDetailsNode.class);
    private static final String TENANT_PREFIX = "tenant_";

    @Override
    protected TbGetTenantDetailsNodeConfiguration loadNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        TbGetTenantDetailsNodeConfiguration config = (TbGetTenantDetailsNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetTenantDetailsNodeConfiguration.class);
        this.checkIfDetailsListIsNotEmptyOrElseThrow(config.getDetailsList());
        return config;
    }

    @Override
    protected String getPrefix() {
        return TENANT_PREFIX;
    }

    @Override
    protected ListenableFuture<Tenant> getContactBasedFuture(TbContext ctx, TbMsg msg) {
        return ctx.getTenantService().findTenantByIdAsync(ctx.getTenantId(), ctx.getTenantId());
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        return fromVersion == 0 ? this.upgradeRuleNodesWithOldPropertyToUseFetchTo(oldConfiguration, "addToMetadata", TbMsgSource.METADATA.name(), TbMsgSource.DATA.name()) : new TbPair<Boolean, JsonNode>((Object)false, (Object)oldConfiguration);
    }
}

