/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDataNode;
import org.thingsboard.rule.engine.metadata.TbGetEntityDataNodeConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.util.TbPair;

@RuleNode(type=ComponentType.ENRICHMENT, name="tenant attributes", configClazz=TbGetEntityDataNodeConfiguration.class, version=1, nodeDescription="Adds message originator tenant attributes or latest telemetry into message or message metadata", nodeDetails="Useful when you need to retrieve some common configuration or threshold set that is stored as tenant attributes or telemetry data and use it for further message processing.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeTenantAttributesConfig")
public class TbGetTenantAttributeNode
extends TbAbstractGetEntityDataNode<TenantId> {
    private static final Logger log = LoggerFactory.getLogger(TbGetTenantAttributeNode.class);

    @Override
    public TbGetEntityDataNodeConfiguration loadNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        TbGetEntityDataNodeConfiguration config = (TbGetEntityDataNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetEntityDataNodeConfiguration.class);
        this.checkIfMappingIsNotEmptyOrElseThrow(config.getDataMapping());
        this.checkDataToFetchSupportedOrElseThrow(config.getDataToFetch());
        return config;
    }

    @Override
    public ListenableFuture<TenantId> findEntityAsync(TbContext ctx, EntityId originator) {
        return Futures.immediateFuture((Object)ctx.getTenantId());
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        return fromVersion == 0 ? this.upgradeToUseFetchToAndDataToFetch(oldConfiguration) : new TbPair((Object)false, (Object)oldConfiguration);
    }
}

