/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.DataToFetch;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDataNode;
import org.thingsboard.rule.engine.metadata.TbGetRelatedDataNodeConfiguration;
import org.thingsboard.rule.engine.util.EntitiesRelatedEntityIdAsyncLoader;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.util.TbPair;

@RuleNode(type=ComponentType.ENRICHMENT, name="related entity data", configClazz=TbGetRelatedDataNodeConfiguration.class, version=1, nodeDescription="Adds originators related entity attributes or latest telemetry or fields into message or message metadata", nodeDetails="Related entity lookup based on the configured relation query. If multiple related entities are found, only first entity is used for message enrichment, other entities are discarded. Useful when you need to retrieve data from an entity that has a relation to the message originator and use them for further message processing.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeRelatedAttributesConfig")
public class TbGetRelatedAttributeNode
extends TbAbstractGetEntityDataNode<EntityId> {
    private static final Logger log = LoggerFactory.getLogger(TbGetRelatedAttributeNode.class);
    private static final String RELATED_ENTITY_NOT_FOUND_MESSAGE = "Failed to find related entity to message originator using relation query specified in the configuration!";

    @Override
    public TbGetRelatedDataNodeConfiguration loadNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        TbGetRelatedDataNodeConfiguration config = (TbGetRelatedDataNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetRelatedDataNodeConfiguration.class);
        this.checkIfMappingIsNotEmptyOrElseThrow(config.getDataMapping());
        this.checkDataToFetchSupportedOrElseThrow(config.getDataToFetch());
        return config;
    }

    @Override
    public ListenableFuture<EntityId> findEntityAsync(TbContext ctx, EntityId originator) {
        TbGetRelatedDataNodeConfiguration relatedAttrConfig = (TbGetRelatedDataNodeConfiguration)this.config;
        return Futures.transformAsync(EntitiesRelatedEntityIdAsyncLoader.findEntityAsync(ctx, originator, relatedAttrConfig.getRelationsQuery()), this.checkIfEntityIsPresentOrThrow(RELATED_ENTITY_NOT_FOUND_MESSAGE), (Executor)ctx.getDbCallbackExecutor());
    }

    @Override
    protected void checkDataToFetchSupportedOrElseThrow(DataToFetch dataToFetch) throws TbNodeException {
        if (dataToFetch == null) {
            throw new TbNodeException("DataToFetch property cannot be null! Supported values are: " + Arrays.toString((Object[])DataToFetch.values()));
        }
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        return fromVersion == 0 ? this.upgradeToUseFetchToAndDataToFetch(oldConfiguration) : new TbPair((Object)false, (Object)oldConfiguration);
    }
}

