/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetMappedDataNode;
import org.thingsboard.rule.engine.metadata.TbGetOriginatorFieldsConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="originator fields", configClazz=TbGetOriginatorFieldsConfiguration.class, version=1, nodeDescription="Adds message originator fields values into message or message metadata", nodeDetails="Fetches fields values specified in the mapping. If specified field is not part of originator fields it will be ignored. Useful when you need to retrieve originator fields and use them for further message processing.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeOriginatorFieldsConfig")
public class TbGetOriginatorFieldsNode
extends TbAbstractGetMappedDataNode<EntityId, TbGetOriginatorFieldsConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbGetOriginatorFieldsNode.class);
    protected static final String DATA_MAPPING_PROPERTY_NAME = "dataMapping";
    protected static final String OLD_DATA_MAPPING_PROPERTY_NAME = "fieldsMapping";

    @Override
    protected TbGetOriginatorFieldsConfiguration loadNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        TbGetOriginatorFieldsConfiguration config = (TbGetOriginatorFieldsConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetOriginatorFieldsConfiguration.class);
        this.checkIfMappingIsNotEmptyOrElseThrow(config.getDataMapping());
        return config;
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        ObjectNode msgDataAsJsonNode = TbMsgSource.DATA.equals((Object)this.fetchTo) ? this.getMsgDataAsObjectNode(msg) : null;
        this.processFieldsData(ctx, msg, msg.getOriginator(), msgDataAsJsonNode, ((TbGetOriginatorFieldsConfiguration)this.config).isIgnoreNullStrings());
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        if (fromVersion == 0) {
            ObjectNode newConfigObjectNode = (ObjectNode)oldConfiguration;
            if (!newConfigObjectNode.has(OLD_DATA_MAPPING_PROPERTY_NAME)) {
                throw new TbNodeException("property to update: 'fieldsMapping' doesn't exists in configuration!");
            }
            newConfigObjectNode.set(DATA_MAPPING_PROPERTY_NAME, newConfigObjectNode.get(OLD_DATA_MAPPING_PROPERTY_NAME));
            newConfigObjectNode.remove(OLD_DATA_MAPPING_PROPERTY_NAME);
            newConfigObjectNode.put("fetchTo", TbMsgSource.METADATA.name());
            return new TbPair((Object)true, (Object)newConfigObjectNode);
        }
        return new TbPair((Object)false, (Object)oldConfiguration);
    }
}

