/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDetailsNode;
import org.thingsboard.rule.engine.metadata.TbGetCustomerDetailsNodeConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.HasCustomerId;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityViewId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.ENRICHMENT, name="customer details", configClazz=TbGetCustomerDetailsNodeConfiguration.class, version=1, nodeDescription="Adds message originator customer details into message or message metadata", nodeDetails="Useful in multi-customer solutions where we need dynamically use customer contact information such as email, phone, address, etc., for notifications via email, SMS, and other notification providers.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeEntityDetailsConfig")
public class TbGetCustomerDetailsNode
extends TbAbstractGetEntityDetailsNode<TbGetCustomerDetailsNodeConfiguration, CustomerId> {
    private static final Logger log = LoggerFactory.getLogger(TbGetCustomerDetailsNode.class);
    private static final String CUSTOMER_PREFIX = "customer_";

    @Override
    protected TbGetCustomerDetailsNodeConfiguration loadNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        TbGetCustomerDetailsNodeConfiguration config = (TbGetCustomerDetailsNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetCustomerDetailsNodeConfiguration.class);
        this.checkIfDetailsListIsNotEmptyOrElseThrow(config.getDetailsList());
        return config;
    }

    @Override
    protected String getPrefix() {
        return CUSTOMER_PREFIX;
    }

    @Override
    protected ListenableFuture<Customer> getContactBasedFuture(TbContext ctx, TbMsg msg) {
        switch (msg.getOriginator().getEntityType()) {
            case DEVICE: {
                return Futures.transformAsync((ListenableFuture)ctx.getDeviceService().findDeviceByIdAsync(ctx.getTenantId(), new DeviceId(msg.getOriginator().getId())), device -> this.getCustomerFuture(ctx, (HasCustomerId)device, msg.getOriginator()), (Executor)ctx.getDbCallbackExecutor());
            }
            case ASSET: {
                return Futures.transformAsync((ListenableFuture)ctx.getAssetService().findAssetByIdAsync(ctx.getTenantId(), new AssetId(msg.getOriginator().getId())), asset -> this.getCustomerFuture(ctx, (HasCustomerId)asset, msg.getOriginator()), (Executor)ctx.getDbCallbackExecutor());
            }
            case ENTITY_VIEW: {
                return Futures.transformAsync((ListenableFuture)ctx.getEntityViewService().findEntityViewByIdAsync(ctx.getTenantId(), new EntityViewId(msg.getOriginator().getId())), entityView -> this.getCustomerFuture(ctx, (HasCustomerId)entityView, msg.getOriginator()), (Executor)ctx.getDbCallbackExecutor());
            }
            case USER: {
                return Futures.transformAsync((ListenableFuture)ctx.getUserService().findUserByIdAsync(ctx.getTenantId(), new UserId(msg.getOriginator().getId())), user -> this.getCustomerFuture(ctx, (HasCustomerId)user, msg.getOriginator()), (Executor)ctx.getDbCallbackExecutor());
            }
            case EDGE: {
                return Futures.transformAsync((ListenableFuture)ctx.getEdgeService().findEdgeByIdAsync(ctx.getTenantId(), new EdgeId(msg.getOriginator().getId())), edge -> this.getCustomerFuture(ctx, (HasCustomerId)edge, msg.getOriginator()), (Executor)ctx.getDbCallbackExecutor());
            }
        }
        return Futures.immediateFailedFuture((Throwable)new NoSuchElementException("Entity with entityType '" + msg.getOriginator().getEntityType() + "' is not supported."));
    }

    private ListenableFuture<Customer> getCustomerFuture(TbContext ctx, HasCustomerId hasCustomerId, EntityId originator) {
        if (hasCustomerId == null) {
            return Futures.immediateFuture(null);
        }
        if (hasCustomerId.getCustomerId() == null || hasCustomerId.getCustomerId().isNullUid()) {
            if (hasCustomerId instanceof HasName) {
                HasName hasName = (HasName)hasCustomerId;
                throw new RuntimeException(originator.getEntityType().getNormalName() + " with name '" + hasName.getName() + "' is not assigned to Customer!");
            }
            throw new RuntimeException(originator.getEntityType().getNormalName() + " with id '" + originator + "' is not assigned to Customer!");
        }
        return ctx.getCustomerService().findCustomerByIdAsync(ctx.getTenantId(), hasCustomerId.getCustomerId());
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        return fromVersion == 0 ? this.upgradeRuleNodesWithOldPropertyToUseFetchTo(oldConfiguration, "addToMetadata", TbMsgSource.METADATA.name(), TbMsgSource.DATA.name()) : new TbPair<Boolean, JsonNode>((Object)false, (Object)oldConfiguration);
    }
}

