/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDataNode;
import org.thingsboard.rule.engine.metadata.TbGetEntityDataNodeConfiguration;
import org.thingsboard.rule.engine.util.EntitiesCustomerIdAsyncLoader;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.util.TbPair;

@RuleNode(type=ComponentType.ENRICHMENT, name="customer attributes", configClazz=TbGetEntityDataNodeConfiguration.class, version=1, nodeDescription="Adds message originator customer attributes or latest telemetry into message or message metadata", nodeDetails="Useful in multi-customer solutions where each customer has a different configuration or threshold set that is stored as customer attributes or telemetry data and used for dynamic message filtering, transformation, or actions such as alarm creation if the threshold is exceeded.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeCustomerAttributesConfig")
public class TbGetCustomerAttributeNode
extends TbAbstractGetEntityDataNode<CustomerId> {
    private static final Logger log = LoggerFactory.getLogger(TbGetCustomerAttributeNode.class);
    private static final String CUSTOMER_NOT_FOUND_MESSAGE = "Failed to find customer for entity with id: %s and type: %s";

    @Override
    protected TbGetEntityDataNodeConfiguration loadNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        TbGetEntityDataNodeConfiguration config = (TbGetEntityDataNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbGetEntityDataNodeConfiguration.class);
        this.checkIfMappingIsNotEmptyOrElseThrow(config.getDataMapping());
        this.checkDataToFetchSupportedOrElseThrow(config.getDataToFetch());
        return config;
    }

    @Override
    protected ListenableFuture<CustomerId> findEntityAsync(TbContext ctx, EntityId originator) {
        return Futures.transformAsync(EntitiesCustomerIdAsyncLoader.findEntityIdAsync(ctx, originator), this.checkIfEntityIsPresentOrThrow(String.format(CUSTOMER_NOT_FOUND_MESSAGE, originator.getId(), originator.getEntityType().getNormalName())), (Executor)ctx.getDbCallbackExecutor());
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        return fromVersion == 0 ? this.upgradeToUseFetchToAndDataToFetch(oldConfiguration) : new TbPair((Object)false, (Object)oldConfiguration);
    }
}

