/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractNodeWithFetchTo;
import org.thingsboard.rule.engine.metadata.TbFetchDeviceCredentialsNodeConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

@RuleNode(type=ComponentType.ENRICHMENT, name="fetch device credentials", version=1, configClazz=TbFetchDeviceCredentialsNodeConfiguration.class, nodeDescription="Adds device credentials to the message or message metadata", nodeDetails="if message originator type is Device and device credentials was successfully fetched, rule node enriches message or message metadata with <i>credentialsType</i> and <i>credentials</i> properties. Useful when you need to fetch device credentials and use them for further message processing. For example, use device credentials to interact with external systems.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbEnrichmentNodeFetchDeviceCredentialsConfig")
public class TbFetchDeviceCredentialsNode
extends TbAbstractNodeWithFetchTo<TbFetchDeviceCredentialsNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbFetchDeviceCredentialsNode.class);
    private static final String CREDENTIALS = "credentials";
    private static final String CREDENTIALS_TYPE = "credentialsType";

    @Override
    protected TbFetchDeviceCredentialsNodeConfiguration loadNodeConfiguration(TbNodeConfiguration configuration) throws TbNodeException {
        return (TbFetchDeviceCredentialsNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbFetchDeviceCredentialsNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws ExecutionException, InterruptedException, TbNodeException {
        ObjectNode msgDataAsObjectNode;
        EntityId originator = msg.getOriginator();
        ObjectNode objectNode = msgDataAsObjectNode = TbMsgSource.DATA.equals((Object)this.fetchTo) ? this.getMsgDataAsObjectNode(msg) : null;
        if (!EntityType.DEVICE.equals((Object)originator.getEntityType())) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Unsupported originator type: " + originator.getEntityType() + "!"));
            return;
        }
        DeviceId deviceId = new DeviceId(msg.getOriginator().getId());
        DeviceCredentials deviceCredentials = ctx.getDeviceCredentialsService().findDeviceCredentialsByDeviceId(ctx.getTenantId(), deviceId);
        if (deviceCredentials == null) {
            ctx.tellFailure(msg, (Throwable)new RuntimeException("Failed to get Device Credentials for device: " + deviceId + "!"));
            return;
        }
        DeviceCredentialsType credentialsType = deviceCredentials.getCredentialsType();
        JsonNode credentialsInfo = ctx.getDeviceCredentialsService().toCredentialsInfo(deviceCredentials);
        TbMsgMetaData metaData = msg.getMetaData().copy();
        if (TbMsgSource.METADATA.equals((Object)this.fetchTo)) {
            metaData.putValue(CREDENTIALS_TYPE, credentialsType.name());
            if (credentialsType.equals((Object)DeviceCredentialsType.ACCESS_TOKEN) || credentialsType.equals((Object)DeviceCredentialsType.X509_CERTIFICATE)) {
                metaData.putValue(CREDENTIALS, credentialsInfo.asText());
            } else {
                metaData.putValue(CREDENTIALS, JacksonUtil.toString((Object)credentialsInfo));
            }
        } else if (TbMsgSource.DATA.equals((Object)this.fetchTo)) {
            msgDataAsObjectNode.put(CREDENTIALS_TYPE, credentialsType.name());
            msgDataAsObjectNode.set(CREDENTIALS, credentialsInfo);
        }
        TbMsg transformedMsg = this.transformMessage(msg, msgDataAsObjectNode, metaData);
        ctx.tellSuccess(transformedMsg);
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        return fromVersion == 0 ? this.upgradeRuleNodesWithOldPropertyToUseFetchTo(oldConfiguration, "fetchToMetadata", TbMsgSource.METADATA.name(), TbMsgSource.DATA.name()) : new TbPair<Boolean, JsonNode>((Object)false, (Object)oldConfiguration);
    }
}

