/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.metadata.TbAbstractFetchToNodeConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public abstract class TbAbstractNodeWithFetchTo<C extends TbAbstractFetchToNodeConfiguration>
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractNodeWithFetchTo.class);
    protected static final String FETCH_TO_PROPERTY_NAME = "fetchTo";
    protected C config;
    protected TbMsgSource fetchTo;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = this.loadNodeConfiguration(configuration);
        if (((TbAbstractFetchToNodeConfiguration)this.config).getFetchTo() == null) {
            throw new TbNodeException("FetchTo option can't be null! Allowed values: " + Arrays.toString((Object[])TbMsgSource.values()));
        }
        this.fetchTo = ((TbAbstractFetchToNodeConfiguration)this.config).getFetchTo();
    }

    protected abstract C loadNodeConfiguration(TbNodeConfiguration var1) throws TbNodeException;

    protected <I extends EntityId> AsyncFunction<I, I> checkIfEntityIsPresentOrThrow(String message) {
        return id -> {
            if (id == null || id.isNullUid()) {
                return Futures.immediateFailedFuture((Throwable)new NoSuchElementException(message));
            }
            return Futures.immediateFuture((Object)id);
        };
    }

    protected ObjectNode getMsgDataAsObjectNode(TbMsg msg) {
        JsonNode msgDataNode = JacksonUtil.toJsonNode((String)msg.getData());
        if (msgDataNode == null || !msgDataNode.isObject()) {
            throw new IllegalArgumentException("Message body is not an object!");
        }
        return (ObjectNode)msgDataNode;
    }

    protected void enrichMessage(ObjectNode msgData, TbMsgMetaData metaData, KvEntry kvEntry, String targetKey) {
        if (TbMsgSource.DATA.equals((Object)this.fetchTo)) {
            JacksonUtil.addKvEntry((ObjectNode)msgData, (KvEntry)kvEntry, (String)targetKey);
        } else if (TbMsgSource.METADATA.equals((Object)this.fetchTo)) {
            metaData.putValue(targetKey, kvEntry.getValueAsString());
        }
    }

    protected TbMsg transformMessage(TbMsg msg, ObjectNode msgDataNode, TbMsgMetaData msgMetaData) {
        switch (this.fetchTo) {
            case DATA: {
                return TbMsg.transformMsgData((TbMsg)msg, (String)JacksonUtil.toString((Object)msgDataNode));
            }
            case METADATA: {
                return TbMsg.transformMsgMetadata((TbMsg)msg, (TbMsgMetaData)msgMetaData);
            }
        }
        log.debug("Unexpected FetchTo value: {}. Allowed values: {}", (Object)this.fetchTo, (Object)TbMsgSource.values());
        return msg;
    }

    protected TbPair<Boolean, JsonNode> upgradeRuleNodesWithOldPropertyToUseFetchTo(JsonNode oldConfiguration, String oldProperty, String ifTrue, String ifFalse) throws TbNodeException {
        ObjectNode newConfig = (ObjectNode)oldConfiguration;
        if (!newConfig.has(oldProperty)) {
            throw new TbNodeException("property to update: '" + oldProperty + "' doesn't exists in configuration!");
        }
        return this.upgradeConfigurationToUseFetchTo(oldProperty, ifTrue, ifFalse, newConfig);
    }

    protected TbPair<Boolean, JsonNode> upgradeConfigurationToUseFetchTo(String oldProperty, String ifTrue, String ifFalse, ObjectNode newConfig) throws TbNodeException {
        String value = newConfig.get(oldProperty).asText();
        if ("true".equals(value)) {
            newConfig.remove(oldProperty);
            newConfig.put(FETCH_TO_PROPERTY_NAME, ifTrue);
            return new TbPair((Object)true, (Object)newConfig);
        }
        if ("false".equals(value)) {
            newConfig.remove(oldProperty);
            newConfig.put(FETCH_TO_PROPERTY_NAME, ifFalse);
            return new TbPair((Object)true, (Object)newConfig);
        }
        throw new TbNodeException("property to update: '" + oldProperty + "' has unexpected value: " + value + ". Allowed values: true or false!");
    }
}

