/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractNodeWithFetchTo;
import org.thingsboard.rule.engine.metadata.TbGetMappedDataNodeConfiguration;
import org.thingsboard.rule.engine.util.EntitiesFieldsAsyncLoader;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public abstract class TbAbstractGetMappedDataNode<T extends EntityId, C extends TbGetMappedDataNodeConfiguration>
extends TbAbstractNodeWithFetchTo<C> {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractGetMappedDataNode.class);

    protected void checkIfMappingIsNotEmptyOrElseThrow(Map<String, String> dataMapping) throws TbNodeException {
        if (dataMapping == null || dataMapping.isEmpty()) {
            throw new TbNodeException("At least one mapping entry should be specified!");
        }
    }

    protected void processFieldsData(TbContext ctx, TbMsg msg, T entityId, ObjectNode msgDataAsJsonNode, boolean ignoreNullStrings) {
        Map<String, String> mappingsMap = this.processFieldsMappingPatterns(msg);
        DonAsynchron.withCallback(this.getEntityFieldsAsync(ctx, (EntityId)entityId, mappingsMap, ignoreNullStrings), data -> this.putFieldsDataAndTell(ctx, msg, msgDataAsJsonNode, (Map<String, String>)data), t -> ctx.tellFailure(msg, t), (Executor)MoreExecutors.directExecutor());
    }

    protected void processAttributesKvEntryData(TbContext ctx, TbMsg msg, T entityId, ObjectNode msgDataAsJsonNode) {
        Map<String, String> mappingsMap = this.processKvEntryMappingPatterns(msg);
        List<String> sourceKeys = List.copyOf(mappingsMap.keySet());
        DonAsynchron.withCallback(this.getAttributesAsync(ctx, (EntityId)entityId, sourceKeys), data -> this.putKvEntryDataAndTell(ctx, msg, (List<? extends KvEntry>)data, mappingsMap, msgDataAsJsonNode), t -> ctx.tellFailure(msg, t), (Executor)MoreExecutors.directExecutor());
    }

    protected void processTsKvEntryData(TbContext ctx, TbMsg msg, T entityId, ObjectNode msgDataAsJsonNode) {
        Map<String, String> mappingsMap = this.processKvEntryMappingPatterns(msg);
        List<String> sourceKeys = List.copyOf(mappingsMap.keySet());
        DonAsynchron.withCallback(this.getLatestTelemetryAsync(ctx, (EntityId)entityId, sourceKeys), data -> this.putKvEntryDataAndTell(ctx, msg, (List<? extends KvEntry>)data, mappingsMap, msgDataAsJsonNode), t -> ctx.tellFailure(msg, t), (Executor)MoreExecutors.directExecutor());
    }

    private void putFieldsDataAndTell(TbContext ctx, TbMsg msg, ObjectNode msgDataAsJsonNode, Map<String, String> targetKeysToSourceValuesMap) {
        TbMsgMetaData msgMetaData = msg.getMetaData().copy();
        for (Map.Entry<String, String> entry : targetKeysToSourceValuesMap.entrySet()) {
            String targetKeyName = entry.getKey();
            String sourceFieldValue = entry.getValue();
            if (TbMsgSource.DATA.equals((Object)this.fetchTo)) {
                msgDataAsJsonNode.put(targetKeyName, sourceFieldValue);
                continue;
            }
            if (!TbMsgSource.METADATA.equals((Object)this.fetchTo)) continue;
            msgMetaData.putValue(targetKeyName, sourceFieldValue);
        }
        TbMsg outMsg = this.transformMessage(msg, msgDataAsJsonNode, msgMetaData);
        ctx.tellSuccess(outMsg);
    }

    private void putKvEntryDataAndTell(TbContext ctx, TbMsg msg, List<? extends KvEntry> data, Map<String, String> map, ObjectNode msgData) {
        TbMsgMetaData msgMetaData = msg.getMetaData().copy();
        for (KvEntry kvEntry : data) {
            String targetKey = map.get(kvEntry.getKey());
            this.enrichMessage(msgData, msgMetaData, kvEntry, targetKey);
        }
        ctx.tellSuccess(this.transformMessage(msg, msgData, msgMetaData));
    }

    private Map<String, String> processFieldsMappingPatterns(TbMsg msg) {
        HashMap<String, String> mappingsMap = new HashMap<String, String>();
        ((TbGetMappedDataNodeConfiguration)this.config).getDataMapping().forEach((sourceField, targetKey) -> {
            String patternProcessedTargetKey = TbNodeUtils.processPattern((String)targetKey, (TbMsg)msg);
            mappingsMap.put((String)sourceField, patternProcessedTargetKey);
        });
        return mappingsMap;
    }

    private Map<String, String> processKvEntryMappingPatterns(TbMsg msg) {
        HashMap<String, String> mappingsMap = new HashMap<String, String>();
        ((TbGetMappedDataNodeConfiguration)this.config).getDataMapping().forEach((sourceKey, targetKey) -> {
            String patternProcessedSourceKey = TbNodeUtils.processPattern((String)sourceKey, (TbMsg)msg);
            String patternProcessedTargetKey = TbNodeUtils.processPattern((String)targetKey, (TbMsg)msg);
            mappingsMap.put(patternProcessedSourceKey, patternProcessedTargetKey);
        });
        return mappingsMap;
    }

    private ListenableFuture<Map<String, String>> getEntityFieldsAsync(TbContext ctx, EntityId entityId, Map<String, String> mappingsMap, boolean ignoreNullStrings) {
        return Futures.transform(EntitiesFieldsAsyncLoader.findAsync(ctx, entityId), fieldsData -> {
            HashMap<String, String> targetKeysToSourceValuesMap = new HashMap<String, String>();
            for (Map.Entry mappingEntry : mappingsMap.entrySet()) {
                String sourceFieldName = (String)mappingEntry.getKey();
                String targetKeyName = (String)mappingEntry.getValue();
                String sourceFieldValue = fieldsData.getFieldValue(sourceFieldName, ignoreNullStrings);
                if (sourceFieldValue == null) continue;
                targetKeysToSourceValuesMap.put(targetKeyName, sourceFieldValue);
            }
            return targetKeysToSourceValuesMap;
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<List<KvEntry>> getAttributesAsync(TbContext ctx, EntityId entityId, List<String> attrKeys) {
        ListenableFuture latest = ctx.getAttributesService().find(ctx.getTenantId(), entityId, "SERVER_SCOPE", attrKeys);
        return Futures.transform((ListenableFuture)latest, l -> l.stream().map(i -> i).collect(Collectors.toList()), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<List<KvEntry>> getLatestTelemetryAsync(TbContext ctx, EntityId entityId, List<String> timeseriesKeys) {
        ListenableFuture latest = ctx.getTimeseriesService().findLatest(ctx.getTenantId(), entityId, timeseriesKeys);
        return Futures.transform((ListenableFuture)latest, l -> l.stream().map(i -> i).collect(Collectors.toList()), (Executor)ctx.getDbCallbackExecutor());
    }
}

