/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.metadata.TbAbstractGetEntityDetailsNodeConfiguration;
import org.thingsboard.rule.engine.metadata.TbAbstractNodeWithFetchTo;
import org.thingsboard.rule.engine.util.ContactBasedEntityDetails;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.ContactBased;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public abstract class TbAbstractGetEntityDetailsNode<C extends TbAbstractGetEntityDetailsNodeConfiguration, I extends UUIDBased>
extends TbAbstractNodeWithFetchTo<C> {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractGetEntityDetailsNode.class);

    public void onMsg(TbContext ctx, TbMsg msg) {
        ObjectNode msgDataAsObjectNode = TbMsgSource.DATA.equals((Object)this.fetchTo) ? this.getMsgDataAsObjectNode(msg) : null;
        DonAsynchron.withCallback(this.getDetails(ctx, msg, msgDataAsObjectNode), arg_0 -> ((TbContext)ctx).tellSuccess(arg_0), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    protected abstract String getPrefix();

    protected abstract ListenableFuture<? extends ContactBased<I>> getContactBasedFuture(TbContext var1, TbMsg var2);

    protected void checkIfDetailsListIsNotEmptyOrElseThrow(List<ContactBasedEntityDetails> detailsList) throws TbNodeException {
        if (detailsList == null || detailsList.isEmpty()) {
            throw new TbNodeException("At least one entity detail should be selected!");
        }
    }

    private ListenableFuture<TbMsg> getDetails(TbContext ctx, TbMsg msg, ObjectNode messageData) {
        ListenableFuture<ContactBased<I>> contactBasedFuture = this.getContactBasedFuture(ctx, msg);
        return Futures.transformAsync(contactBasedFuture, contactBased -> {
            if (contactBased == null) {
                return Futures.immediateFuture((Object)msg);
            }
            TbMsgMetaData msgMetaData = msg.getMetaData().copy();
            this.fetchEntityDetailsToMsg((ContactBased<I>)contactBased, messageData, msgMetaData);
            return Futures.immediateFuture((Object)this.transformMessage(msg, messageData, msgMetaData));
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void fetchEntityDetailsToMsg(ContactBased<I> contactBased, ObjectNode messageData, TbMsgMetaData msgMetaData) {
        String value = null;
        for (ContactBasedEntityDetails entityDetail : ((TbAbstractGetEntityDetailsNodeConfiguration)this.config).getDetailsList()) {
            switch (entityDetail) {
                case ID: {
                    value = contactBased.getId().getId().toString();
                    break;
                }
                case TITLE: {
                    value = contactBased.getName();
                    break;
                }
                case ADDRESS: {
                    value = contactBased.getAddress();
                    break;
                }
                case ADDRESS2: {
                    value = contactBased.getAddress2();
                    break;
                }
                case CITY: {
                    value = contactBased.getCity();
                    break;
                }
                case COUNTRY: {
                    value = contactBased.getCountry();
                    break;
                }
                case STATE: {
                    value = contactBased.getState();
                    break;
                }
                case EMAIL: {
                    value = contactBased.getEmail();
                    break;
                }
                case PHONE: {
                    value = contactBased.getPhone();
                    break;
                }
                case ZIP: {
                    value = contactBased.getZip();
                    break;
                }
                case ADDITIONAL_INFO: {
                    if (!contactBased.getAdditionalInfo().hasNonNull("description")) break;
                    value = contactBased.getAdditionalInfo().get("description").asText();
                }
            }
            if (value == null) continue;
            this.setDetail(entityDetail.getRuleEngineName(), value, messageData, msgMetaData);
        }
    }

    private void setDetail(String property, String value, ObjectNode messageData, TbMsgMetaData msgMetaData) {
        String fieldName = this.getPrefix() + property;
        if (TbMsgSource.METADATA.equals((Object)this.fetchTo)) {
            msgMetaData.putValue(fieldName, value);
        } else if (TbMsgSource.DATA.equals((Object)this.fetchTo)) {
            messageData.put(fieldName, value);
        }
    }
}

