/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.metadata.DataToFetch;
import org.thingsboard.rule.engine.metadata.TbAbstractGetMappedDataNode;
import org.thingsboard.rule.engine.metadata.TbGetEntityDataNodeConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class TbAbstractGetEntityDataNode<T extends EntityId>
extends TbAbstractGetMappedDataNode<T, TbGetEntityDataNodeConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractGetEntityDataNode.class);
    private static final String DATA_TO_FETCH_PROPERTY_NAME = "dataToFetch";
    private static final String OLD_DATA_TO_FETCH_PROPERTY_NAME = "telemetry";
    private static final String DATA_MAPPING_PROPERTY_NAME = "dataMapping";
    private static final String OLD_DATA_MAPPING_PROPERTY_NAME = "attrMapping";
    private static final String DATA_TO_FETCH_VALIDATION_MSG = "DataToFetch property has invalid value: %s. Only ATTRIBUTES and LATEST_TELEMETRY values supported!";

    public void onMsg(TbContext ctx, TbMsg msg) {
        ObjectNode msgDataAsObjectNode = TbMsgSource.DATA.equals((Object)this.fetchTo) ? this.getMsgDataAsObjectNode(msg) : null;
        DonAsynchron.withCallback(this.findEntityAsync(ctx, msg.getOriginator()), entityId -> this.processDataAndTell(ctx, msg, entityId, msgDataAsObjectNode), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    protected abstract ListenableFuture<T> findEntityAsync(TbContext var1, EntityId var2);

    protected void checkDataToFetchSupportedOrElseThrow(DataToFetch dataToFetch) throws TbNodeException {
        if (dataToFetch == null || dataToFetch.equals((Object)DataToFetch.FIELDS)) {
            throw new TbNodeException(String.format(DATA_TO_FETCH_VALIDATION_MSG, new Object[]{dataToFetch}));
        }
    }

    protected void processDataAndTell(TbContext ctx, TbMsg msg, T entityId, ObjectNode msgDataAsJsonNode) {
        DataToFetch dataToFetch = ((TbGetEntityDataNodeConfiguration)this.config).getDataToFetch();
        switch (dataToFetch) {
            case ATTRIBUTES: {
                this.processAttributesKvEntryData(ctx, msg, entityId, msgDataAsJsonNode);
                break;
            }
            case LATEST_TELEMETRY: {
                this.processTsKvEntryData(ctx, msg, entityId, msgDataAsJsonNode);
                break;
            }
            case FIELDS: {
                this.processFieldsData(ctx, msg, entityId, msgDataAsJsonNode, true);
            }
        }
    }

    protected TbPair<Boolean, JsonNode> upgradeToUseFetchToAndDataToFetch(JsonNode oldConfiguration) throws TbNodeException {
        ObjectNode newConfigObjectNode = (ObjectNode)oldConfiguration;
        if (!newConfigObjectNode.has(OLD_DATA_TO_FETCH_PROPERTY_NAME)) {
            throw new TbNodeException("property to update: 'telemetry' doesn't exists in configuration!");
        }
        if (!newConfigObjectNode.has(OLD_DATA_MAPPING_PROPERTY_NAME)) {
            throw new TbNodeException("property to update: 'attrMapping' doesn't exists in configuration!");
        }
        newConfigObjectNode.set(DATA_MAPPING_PROPERTY_NAME, newConfigObjectNode.get(OLD_DATA_MAPPING_PROPERTY_NAME));
        newConfigObjectNode.remove(OLD_DATA_MAPPING_PROPERTY_NAME);
        String value = newConfigObjectNode.get(OLD_DATA_TO_FETCH_PROPERTY_NAME).asText();
        if ("true".equals(value)) {
            newConfigObjectNode.remove(OLD_DATA_TO_FETCH_PROPERTY_NAME);
            newConfigObjectNode.put(DATA_TO_FETCH_PROPERTY_NAME, DataToFetch.LATEST_TELEMETRY.name());
        } else if ("false".equals(value)) {
            newConfigObjectNode.remove(OLD_DATA_TO_FETCH_PROPERTY_NAME);
            newConfigObjectNode.put(DATA_TO_FETCH_PROPERTY_NAME, DataToFetch.ATTRIBUTES.name());
        } else {
            throw new TbNodeException("property to update: 'telemetry' has unexpected value: " + value + ". Allowed values: true or false!");
        }
        newConfigObjectNode.put("fetchTo", TbMsgSource.METADATA.name());
        return new TbPair((Object)true, (Object)newConfigObjectNode);
    }
}

