/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.metadata.TbAbstractNodeWithFetchTo;
import org.thingsboard.rule.engine.metadata.TbGetAttributesNodeConfiguration;
import org.thingsboard.rule.engine.util.TbMsgSource;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgMetaData;

public abstract class TbAbstractGetAttributesNode<C extends TbGetAttributesNodeConfiguration, T extends EntityId>
extends TbAbstractNodeWithFetchTo<C> {
    private static final Logger log = LoggerFactory.getLogger(TbAbstractGetAttributesNode.class);
    private static final String VALUE = "value";
    private static final String TS = "ts";
    private boolean isTellFailureIfAbsent;
    private boolean getLatestValueWithTs;

    @Override
    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        super.init(ctx, configuration);
        this.getLatestValueWithTs = ((TbGetAttributesNodeConfiguration)this.config).isGetLatestValueWithTs();
        this.isTellFailureIfAbsent = BooleanUtils.toBooleanDefaultIfNull((Boolean)((TbGetAttributesNodeConfiguration)this.config).isTellFailureIfAbsent(), (boolean)true);
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws TbNodeException {
        ObjectNode msgDataAsObjectNode = TbMsgSource.DATA.equals((Object)this.fetchTo) ? this.getMsgDataAsObjectNode(msg) : null;
        DonAsynchron.withCallback(this.findEntityIdAsync(ctx, msg), entityId -> this.safePutAttributes(ctx, msg, msgDataAsObjectNode, entityId), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    protected abstract ListenableFuture<T> findEntityIdAsync(TbContext var1, TbMsg var2);

    @Override
    protected TbPair<Boolean, JsonNode> upgradeRuleNodesWithOldPropertyToUseFetchTo(JsonNode oldConfiguration, String oldProperty, String ifTrue, String ifFalse) throws TbNodeException {
        ObjectNode newConfigObjectNode = (ObjectNode)oldConfiguration;
        if (!newConfigObjectNode.has(oldProperty)) {
            newConfigObjectNode.put("fetchTo", TbMsgSource.METADATA.name());
            return new TbPair((Object)true, (Object)newConfigObjectNode);
        }
        if (newConfigObjectNode.get(oldProperty).isNull()) {
            newConfigObjectNode.remove(oldProperty);
            newConfigObjectNode.put("fetchTo", TbMsgSource.METADATA.name());
            return new TbPair((Object)true, (Object)newConfigObjectNode);
        }
        return this.upgradeConfigurationToUseFetchTo(oldProperty, ifTrue, ifFalse, newConfigObjectNode);
    }

    private void safePutAttributes(TbContext ctx, TbMsg msg, ObjectNode msgDataNode, T entityId) {
        ConcurrentHashMap.KeySetView failuresPairSet = ConcurrentHashMap.newKeySet();
        ListenableFuture getKvEntryPairFutures = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{this.getAttrAsync(ctx, (EntityId)entityId, "CLIENT_SCOPE", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getClientAttributeNames(), (TbMsg)msg), failuresPairSet), this.getAttrAsync(ctx, (EntityId)entityId, "SHARED_SCOPE", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getSharedAttributeNames(), (TbMsg)msg), failuresPairSet), this.getAttrAsync(ctx, (EntityId)entityId, "SERVER_SCOPE", TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getServerAttributeNames(), (TbMsg)msg), failuresPairSet), this.getLatestTelemetry(ctx, (EntityId)entityId, TbNodeUtils.processPatterns(((TbGetAttributesNodeConfiguration)this.config).getLatestTsKeyNames(), (TbMsg)msg), failuresPairSet)});
        DonAsynchron.withCallback((ListenableFuture)getKvEntryPairFutures, futuresList -> {
            TbMsgMetaData msgMetaData = msg.getMetaData().copy();
            futuresList.stream().filter(Objects::nonNull).forEach(kvEntriesPair -> {
                String keyScope = (String)kvEntriesPair.getFirst();
                List kvEntryList = (List)kvEntriesPair.getSecond();
                String prefix = this.getPrefix(keyScope);
                kvEntryList.forEach(kvEntry -> {
                    String targetKey = prefix + kvEntry.getKey();
                    this.enrichMessage(msgDataNode, msgMetaData, (KvEntry)kvEntry, targetKey);
                });
            });
            TbMsg outMsg = this.transformMessage(msg, msgDataNode, msgMetaData);
            if (failuresPairSet.isEmpty()) {
                ctx.tellSuccess(outMsg);
            } else {
                ctx.tellFailure(outMsg, (Throwable)this.reportFailures(failuresPairSet));
            }
        }, t -> ctx.tellFailure(msg, t), (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<TbPair<String, List<AttributeKvEntry>>> getAttrAsync(TbContext ctx, EntityId entityId, String scope, List<String> keys, Set<TbPair<String, List<String>>> failuresPairSet) {
        if (CollectionUtils.isEmpty(keys)) {
            return Futures.immediateFuture(null);
        }
        ListenableFuture attributeKvEntryListFuture = ctx.getAttributesService().find(ctx.getTenantId(), entityId, scope, keys);
        return Futures.transform((ListenableFuture)attributeKvEntryListFuture, attributeKvEntryList -> {
            if (this.isTellFailureIfAbsent && attributeKvEntryList.size() != keys.size()) {
                List<String> nonExistentKeys = this.getNonExistentKeys((List<AttributeKvEntry>)attributeKvEntryList, keys);
                failuresPairSet.add(new TbPair((Object)scope, nonExistentKeys));
            }
            return new TbPair((Object)scope, attributeKvEntryList);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<TbPair<String, List<TsKvEntry>>> getLatestTelemetry(TbContext ctx, EntityId entityId, List<String> keys, Set<TbPair<String, List<String>>> failuresPairSet) {
        if (CollectionUtils.isEmpty(keys)) {
            return Futures.immediateFuture(null);
        }
        ListenableFuture latestTelemetryFutures = ctx.getTimeseriesService().findLatest(ctx.getTenantId(), entityId, keys);
        return Futures.transform((ListenableFuture)latestTelemetryFutures, tsKvEntries -> {
            ArrayList listTsKvEntry = new ArrayList();
            ArrayList nonExistentKeys = new ArrayList();
            tsKvEntries.forEach(tsKvEntry -> {
                if (tsKvEntry.getValue() == null) {
                    if (this.isTellFailureIfAbsent) {
                        nonExistentKeys.add(tsKvEntry.getKey());
                    }
                } else if (this.getLatestValueWithTs) {
                    listTsKvEntry.add(this.getValueWithTs((TsKvEntry)tsKvEntry));
                } else {
                    listTsKvEntry.add(new BasicTsKvEntry(tsKvEntry.getTs(), (KvEntry)tsKvEntry));
                }
            });
            if (this.isTellFailureIfAbsent && !nonExistentKeys.isEmpty()) {
                failuresPairSet.add(new TbPair((Object)"LATEST_TS", nonExistentKeys));
            }
            return new TbPair((Object)"LATEST_TS", listTsKvEntry);
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    private TsKvEntry getValueWithTs(TsKvEntry tsKvEntry) {
        ObjectMapper mapper = TbMsgSource.DATA.equals((Object)this.fetchTo) ? JacksonUtil.OBJECT_MAPPER : JacksonUtil.ALLOW_UNQUOTED_FIELD_NAMES_MAPPER;
        ObjectNode value = JacksonUtil.newObjectNode((ObjectMapper)mapper);
        value.put(TS, tsKvEntry.getTs());
        JacksonUtil.addKvEntry((ObjectNode)value, (KvEntry)tsKvEntry, (String)VALUE, (ObjectMapper)mapper);
        return new BasicTsKvEntry(tsKvEntry.getTs(), (KvEntry)new JsonDataEntry(tsKvEntry.getKey(), value.toString()));
    }

    private String getPrefix(String scope) {
        String prefix = "";
        switch (scope) {
            case "CLIENT_SCOPE": {
                prefix = "cs_";
                break;
            }
            case "SHARED_SCOPE": {
                prefix = "shared_";
                break;
            }
            case "SERVER_SCOPE": {
                prefix = "ss_";
            }
        }
        return prefix;
    }

    private List<String> getNonExistentKeys(List<AttributeKvEntry> existingAttributesKvEntry, List<String> allKeys) {
        List existingKeys = existingAttributesKvEntry.stream().map(KvEntry::getKey).collect(Collectors.toList());
        return allKeys.stream().filter(key -> !existingKeys.contains(key)).collect(Collectors.toList());
    }

    private RuntimeException reportFailures(Set<TbPair<String, List<String>>> failuresPairSet) {
        StringBuilder errorMessage = new StringBuilder("The following attribute/telemetry keys is not present in the DB: ").append("\n");
        failuresPairSet.forEach(failurePair -> {
            String scope = (String)failurePair.getFirst();
            List nonExistentKeys = (List)failurePair.getSecond();
            errorMessage.append("\t").append("[").append(scope).append("]:").append(nonExistentKeys.toString()).append("\n");
        });
        failuresPairSet.clear();
        return new RuntimeException(errorMessage.toString());
    }
}

