/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.math;

public enum TbRuleNodeMathFunctionType {
    ADD(2),
    SUB(2),
    MULT(2),
    DIV(2),
    SIN,
    SINH,
    COS,
    COSH,
    TAN,
    TANH,
    ACOS,
    ASIN,
    ATAN,
    ATAN2(2),
    EXP,
    EXPM1,
    SQRT,
    CBRT,
    GET_EXP(1, 1, true),
    HYPOT(2),
    LOG,
    LOG10,
    LOG1P,
    CEIL(1, 1, true),
    FLOOR(1, 1, true),
    FLOOR_DIV(2),
    FLOOR_MOD(2),
    ABS,
    MIN(2),
    MAX(2),
    POW(2),
    SIGNUM,
    RAD,
    DEG,
    CUSTOM(0, 16, false);

    private final int minArgs;
    private final int maxArgs;
    private final boolean integerResult;

    private TbRuleNodeMathFunctionType() {
        this(1, 1, false);
    }

    private TbRuleNodeMathFunctionType(int args) {
        this(args, args, false);
    }

    private TbRuleNodeMathFunctionType(int minArgs, int maxArgs, boolean integerResult) {
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
        this.integerResult = integerResult;
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    public int getMaxArgs() {
        return this.maxArgs;
    }

    public boolean isIntegerResult() {
        return this.integerResult;
    }
}

