/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mail;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbEmail;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.external.TbAbstractExternalNode;
import org.thingsboard.rule.engine.mail.TbSendEmailNodeConfiguration;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.EXTERNAL, name="send email", configClazz=TbSendEmailNodeConfiguration.class, nodeDescription="Sends email message via SMTP server.", nodeDetails="Expects messages with <b>SEND_EMAIL</b> type. Node works only with messages that  where created using <code>to Email</code> transformation Node, please connect this Node with <code>to Email</code> Node using <code>Successful</code> chain.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbExternalNodeSendEmailConfig", icon="send")
public class TbSendEmailNode
extends TbAbstractExternalNode {
    private static final Logger log = LoggerFactory.getLogger(TbSendEmailNode.class);
    private static final String MAIL_PROP = "mail.";
    private TbSendEmailNodeConfiguration config;
    private JavaMailSenderImpl mailSender;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        super.init(ctx);
        this.config = (TbSendEmailNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbSendEmailNodeConfiguration.class);
        try {
            if (!this.config.isUseSystemSmtpSettings()) {
                this.mailSender = this.createMailSender();
            }
        }
        catch (Exception e) {
            throw new TbNodeException(e);
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            this.validateType(msg);
            TbEmail email = this.getEmail(msg);
            TbMsg tbMsg = this.ackIfNeeded(ctx, msg);
            DonAsynchron.withCallback((ListenableFuture)ctx.getMailExecutor().executeAsync(() -> {
                this.sendEmail(ctx, tbMsg, email);
                return null;
            }), ok -> this.tellSuccess(ctx, tbMsg), fail -> this.tellFailure(ctx, tbMsg, (Throwable)fail));
        }
        catch (Exception ex) {
            ctx.tellFailure(msg, (Throwable)ex);
        }
    }

    private void sendEmail(TbContext ctx, TbMsg msg, TbEmail email) throws Exception {
        if (this.config.isUseSystemSmtpSettings()) {
            ctx.getMailService(true).send(ctx.getTenantId(), msg.getCustomerId(), email);
        } else {
            ctx.getMailService(false).send(ctx.getTenantId(), msg.getCustomerId(), email, (JavaMailSender)this.mailSender, (long)this.config.getTimeout());
        }
    }

    private TbEmail getEmail(TbMsg msg) throws IOException {
        TbEmail email = (TbEmail)JacksonUtil.fromString((String)msg.getData(), TbEmail.class);
        if (StringUtils.isBlank((String)email.getTo())) {
            throw new IllegalStateException("Email destination can not be blank [" + email.getTo() + "]");
        }
        return email;
    }

    private void validateType(TbMsg msg) {
        if (!msg.isTypeOf(TbMsgType.SEND_EMAIL)) {
            String type = msg.getType();
            log.warn("Not expected msg type [{}] for SendEmail Node", (Object)type);
            throw new IllegalStateException("Not expected msg type " + type + " for SendEmail Node");
        }
    }

    private JavaMailSenderImpl createMailSender() {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(this.config.getSmtpHost());
        mailSender.setPort(this.config.getSmtpPort());
        mailSender.setUsername(this.config.getUsername());
        mailSender.setPassword(this.config.getPassword());
        mailSender.setJavaMailProperties(this.createJavaMailProperties());
        return mailSender;
    }

    private Properties createJavaMailProperties() {
        Properties javaMailProperties = new Properties();
        String protocol = this.config.getSmtpProtocol();
        javaMailProperties.put("mail.transport.protocol", protocol);
        javaMailProperties.put(MAIL_PROP + protocol + ".host", this.config.getSmtpHost());
        javaMailProperties.put(MAIL_PROP + protocol + ".port", "" + this.config.getSmtpPort());
        javaMailProperties.put(MAIL_PROP + protocol + ".timeout", "" + this.config.getTimeout());
        javaMailProperties.put(MAIL_PROP + protocol + ".auth", String.valueOf(StringUtils.isNotEmpty((String)this.config.getUsername())));
        javaMailProperties.put(MAIL_PROP + protocol + ".starttls.enable", Boolean.valueOf(this.config.isEnableTls()).toString());
        if (this.config.isEnableTls() && StringUtils.isNoneEmpty((String)this.config.getTlsVersion())) {
            javaMailProperties.put(MAIL_PROP + protocol + ".ssl.protocols", this.config.getTlsVersion());
        }
        if (this.config.isEnableProxy()) {
            javaMailProperties.put(MAIL_PROP + protocol + ".proxy.host", this.config.getProxyHost());
            javaMailProperties.put(MAIL_PROP + protocol + ".proxy.port", this.config.getProxyPort());
            if (StringUtils.isNoneEmpty((String)this.config.getProxyUser())) {
                javaMailProperties.put(MAIL_PROP + protocol + ".proxy.user", this.config.getProxyUser());
            }
            if (StringUtils.isNoneEmpty((String)this.config.getProxyPassword())) {
                javaMailProperties.put(MAIL_PROP + protocol + ".proxy.password", this.config.getProxyPassword());
            }
        }
        return javaMailProperties;
    }
}

