/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.mail;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbEmail;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.mail.TbMsgToEmailNodeConfiguration;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.TRANSFORMATION, name="to email", configClazz=TbMsgToEmailNodeConfiguration.class, nodeDescription="Transforms message to email message", nodeDetails="Transforms message to email message. If transformation completed successfully output message type will be set to <code>SEND_EMAIL</code>.<br><br>Output connections: <code>Success</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbTransformationNodeToEmailConfig", icon="email")
public class TbMsgToEmailNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgToEmailNode.class);
    private static final String IMAGES = "images";
    private static final String DYNAMIC = "dynamic";
    private TbMsgToEmailNodeConfiguration config;
    private boolean dynamicMailBodyType;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbMsgToEmailNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbMsgToEmailNodeConfiguration.class);
        this.dynamicMailBodyType = DYNAMIC.equals(this.config.getMailBodyType());
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        try {
            TbEmail email = this.convert(msg);
            TbMsg emailMsg = this.buildEmailMsg(ctx, msg, email);
            ctx.tellNext(emailMsg, "Success");
        }
        catch (Exception ex) {
            log.warn("Can not convert message to email " + ex.getMessage());
            ctx.tellFailure(msg, (Throwable)ex);
        }
    }

    private TbMsg buildEmailMsg(TbContext ctx, TbMsg msg, TbEmail email) {
        String emailJson = JacksonUtil.toString((Object)email);
        return ctx.transformMsg(msg, TbMsgType.SEND_EMAIL, msg.getOriginator(), msg.getMetaData().copy(), emailJson);
    }

    private TbEmail convert(TbMsg msg) {
        TbEmail.TbEmailBuilder builder = TbEmail.builder();
        builder.from(this.fromTemplate(this.config.getFromTemplate(), msg));
        builder.to(this.fromTemplate(this.config.getToTemplate(), msg));
        builder.cc(this.fromTemplate(this.config.getCcTemplate(), msg));
        builder.bcc(this.fromTemplate(this.config.getBccTemplate(), msg));
        String htmlStr = this.dynamicMailBodyType ? this.fromTemplate(this.config.getIsHtmlTemplate(), msg) : this.config.getMailBodyType();
        builder.html(Boolean.parseBoolean(htmlStr));
        builder.subject(this.fromTemplate(this.config.getSubjectTemplate(), msg));
        builder.body(this.fromTemplate(this.config.getBodyTemplate(), msg));
        String imagesStr = msg.getMetaData().getValue(IMAGES);
        if (!StringUtils.isEmpty((String)imagesStr)) {
            Map imgMap = (Map)JacksonUtil.fromString((String)imagesStr, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            builder.images(imgMap);
        }
        return builder.build();
    }

    private String fromTemplate(String template, TbMsg msg) {
        return StringUtils.isNotEmpty((String)template) ? TbNodeUtils.processPattern((String)template, (TbMsg)msg) : null;
    }
}

