/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.kafka;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.serialization.StringSerializer;
import org.thingsboard.rule.engine.api.NodeConfiguration;

public class TbKafkaNodeConfiguration
implements NodeConfiguration<TbKafkaNodeConfiguration> {
    private String topicPattern;
    private String keyPattern;
    private String bootstrapServers;
    private int retries;
    private int batchSize;
    private int linger;
    private int bufferMemory;
    private String acks;
    private String keySerializer;
    private String valueSerializer;
    private Map<String, String> otherProperties;
    private boolean addMetadataKeyValuesAsKafkaHeaders;
    private String kafkaHeadersCharset;

    public TbKafkaNodeConfiguration defaultConfiguration() {
        TbKafkaNodeConfiguration configuration = new TbKafkaNodeConfiguration();
        configuration.setTopicPattern("my-topic");
        configuration.setBootstrapServers("localhost:9092");
        configuration.setRetries(0);
        configuration.setBatchSize(16384);
        configuration.setLinger(0);
        configuration.setBufferMemory(0x2000000);
        configuration.setAcks("-1");
        configuration.setKeySerializer(StringSerializer.class.getName());
        configuration.setValueSerializer(StringSerializer.class.getName());
        configuration.setOtherProperties(Collections.emptyMap());
        configuration.setAddMetadataKeyValuesAsKafkaHeaders(false);
        configuration.setKafkaHeadersCharset("UTF-8");
        return configuration;
    }

    public String getTopicPattern() {
        return this.topicPattern;
    }

    public String getKeyPattern() {
        return this.keyPattern;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getLinger() {
        return this.linger;
    }

    public int getBufferMemory() {
        return this.bufferMemory;
    }

    public String getAcks() {
        return this.acks;
    }

    public String getKeySerializer() {
        return this.keySerializer;
    }

    public String getValueSerializer() {
        return this.valueSerializer;
    }

    public Map<String, String> getOtherProperties() {
        return this.otherProperties;
    }

    public boolean isAddMetadataKeyValuesAsKafkaHeaders() {
        return this.addMetadataKeyValuesAsKafkaHeaders;
    }

    public String getKafkaHeadersCharset() {
        return this.kafkaHeadersCharset;
    }

    public void setTopicPattern(String topicPattern) {
        this.topicPattern = topicPattern;
    }

    public void setKeyPattern(String keyPattern) {
        this.keyPattern = keyPattern;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public void setBufferMemory(int bufferMemory) {
        this.bufferMemory = bufferMemory;
    }

    public void setAcks(String acks) {
        this.acks = acks;
    }

    public void setKeySerializer(String keySerializer) {
        this.keySerializer = keySerializer;
    }

    public void setValueSerializer(String valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public void setOtherProperties(Map<String, String> otherProperties) {
        this.otherProperties = otherProperties;
    }

    public void setAddMetadataKeyValuesAsKafkaHeaders(boolean addMetadataKeyValuesAsKafkaHeaders) {
        this.addMetadataKeyValuesAsKafkaHeaders = addMetadataKeyValuesAsKafkaHeaders;
    }

    public void setKafkaHeadersCharset(String kafkaHeadersCharset) {
        this.kafkaHeadersCharset = kafkaHeadersCharset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbKafkaNodeConfiguration)) {
            return false;
        }
        TbKafkaNodeConfiguration other = (TbKafkaNodeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetries() != other.getRetries()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getLinger() != other.getLinger()) {
            return false;
        }
        if (this.getBufferMemory() != other.getBufferMemory()) {
            return false;
        }
        if (this.isAddMetadataKeyValuesAsKafkaHeaders() != other.isAddMetadataKeyValuesAsKafkaHeaders()) {
            return false;
        }
        String this$topicPattern = this.getTopicPattern();
        String other$topicPattern = other.getTopicPattern();
        if (this$topicPattern == null ? other$topicPattern != null : !this$topicPattern.equals(other$topicPattern)) {
            return false;
        }
        String this$keyPattern = this.getKeyPattern();
        String other$keyPattern = other.getKeyPattern();
        if (this$keyPattern == null ? other$keyPattern != null : !this$keyPattern.equals(other$keyPattern)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$acks = this.getAcks();
        String other$acks = other.getAcks();
        if (this$acks == null ? other$acks != null : !this$acks.equals(other$acks)) {
            return false;
        }
        String this$keySerializer = this.getKeySerializer();
        String other$keySerializer = other.getKeySerializer();
        if (this$keySerializer == null ? other$keySerializer != null : !this$keySerializer.equals(other$keySerializer)) {
            return false;
        }
        String this$valueSerializer = this.getValueSerializer();
        String other$valueSerializer = other.getValueSerializer();
        if (this$valueSerializer == null ? other$valueSerializer != null : !this$valueSerializer.equals(other$valueSerializer)) {
            return false;
        }
        Map<String, String> this$otherProperties = this.getOtherProperties();
        Map<String, String> other$otherProperties = other.getOtherProperties();
        if (this$otherProperties == null ? other$otherProperties != null : !((Object)this$otherProperties).equals(other$otherProperties)) {
            return false;
        }
        String this$kafkaHeadersCharset = this.getKafkaHeadersCharset();
        String other$kafkaHeadersCharset = other.getKafkaHeadersCharset();
        return !(this$kafkaHeadersCharset == null ? other$kafkaHeadersCharset != null : !this$kafkaHeadersCharset.equals(other$kafkaHeadersCharset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbKafkaNodeConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetries();
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getLinger();
        result = result * 59 + this.getBufferMemory();
        result = result * 59 + (this.isAddMetadataKeyValuesAsKafkaHeaders() ? 79 : 97);
        String $topicPattern = this.getTopicPattern();
        result = result * 59 + ($topicPattern == null ? 43 : $topicPattern.hashCode());
        String $keyPattern = this.getKeyPattern();
        result = result * 59 + ($keyPattern == null ? 43 : $keyPattern.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $acks = this.getAcks();
        result = result * 59 + ($acks == null ? 43 : $acks.hashCode());
        String $keySerializer = this.getKeySerializer();
        result = result * 59 + ($keySerializer == null ? 43 : $keySerializer.hashCode());
        String $valueSerializer = this.getValueSerializer();
        result = result * 59 + ($valueSerializer == null ? 43 : $valueSerializer.hashCode());
        Map<String, String> $otherProperties = this.getOtherProperties();
        result = result * 59 + ($otherProperties == null ? 43 : ((Object)$otherProperties).hashCode());
        String $kafkaHeadersCharset = this.getKafkaHeadersCharset();
        result = result * 59 + ($kafkaHeadersCharset == null ? 43 : $kafkaHeadersCharset.hashCode());
        return result;
    }

    public String toString() {
        return "TbKafkaNodeConfiguration(topicPattern=" + this.getTopicPattern() + ", keyPattern=" + this.getKeyPattern() + ", bootstrapServers=" + this.getBootstrapServers() + ", retries=" + this.getRetries() + ", batchSize=" + this.getBatchSize() + ", linger=" + this.getLinger() + ", bufferMemory=" + this.getBufferMemory() + ", acks=" + this.getAcks() + ", keySerializer=" + this.getKeySerializer() + ", valueSerializer=" + this.getValueSerializer() + ", otherProperties=" + this.getOtherProperties() + ", addMetadataKeyValuesAsKafkaHeaders=" + this.isAddMetadataKeyValuesAsKafkaHeaders() + ", kafkaHeadersCharset=" + this.getKafkaHeadersCharset() + ")";
    }
}

