/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.flow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.EmptyNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FLOW, name="checkpoint", configClazz=EmptyNodeConfiguration.class, version=1, hasQueueName=true, nodeDescription="transfers the message to another queue", nodeDetails="After successful transfer incoming message is automatically acknowledged. Queue name is configurable.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbNodeEmptyConfig")
public class TbCheckpointNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbCheckpointNode.class);
    private String queueName;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.queueName = ctx.getQueueName();
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        ctx.enqueueForTellNext(msg, this.queueName, "Success", () -> ctx.ack(msg), error -> ctx.tellFailure(msg, error));
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        boolean hasChanges = false;
        switch (fromVersion) {
            case 0: {
                if (!oldConfiguration.has("queueName")) break;
                hasChanges = true;
                ((ObjectNode)oldConfiguration).remove("queueName");
                break;
            }
        }
        return new TbPair((Object)hasChanges, (Object)oldConfiguration);
    }
}

