/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.EmptyNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.filter.TbAbstractTypeSwitchNode;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.plugin.ComponentType;

@RuleNode(type=ComponentType.FILTER, name="entity type switch", configClazz=EmptyNodeConfiguration.class, relationTypes={}, nodeDescription="Route incoming messages by Message Originator Type", nodeDetails="Routes messages to chain according to the entity type ('Device', 'Asset', etc.).<br><br>Output connections: <i>Message originator type</i> or <code>Failure</code>", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbNodeEmptyConfig")
public class TbOriginatorTypeSwitchNode
extends TbAbstractTypeSwitchNode {
    private static final Logger log = LoggerFactory.getLogger(TbOriginatorTypeSwitchNode.class);

    @Override
    protected String getRelationType(TbContext ctx, EntityId originator) {
        return originator.getEntityType().getNormalName();
    }
}

