/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbOriginatorTypeFilterNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="entity type filter", configClazz=TbOriginatorTypeFilterNodeConfiguration.class, relationTypes={"True", "False"}, nodeDescription="Filter incoming messages by the type of message originator entity", nodeDetails="Checks that the entity type of the incoming message originator matches one of the values specified in the filter.<br><br>Output connections: <code>True</code>, <code>False</code>, <code>Failure</code>", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeOriginatorTypeConfig")
public class TbOriginatorTypeFilterNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbOriginatorTypeFilterNode.class);
    TbOriginatorTypeFilterNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbOriginatorTypeFilterNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbOriginatorTypeFilterNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        EntityType originatorType = msg.getOriginator().getEntityType();
        ctx.tellNext(msg, this.config.getOriginatorTypes().contains(originatorType) ? "True" : "False");
    }
}

