/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.EmptyNodeConfiguration;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="message type switch", configClazz=EmptyNodeConfiguration.class, relationTypes={}, nodeDescription="Route incoming messages by Message Type", nodeDetails="Sends messages with message types <b>\"Post attributes\", \"Post telemetry\", \"RPC Request\"</b> etc. via corresponding chain, otherwise <b>Other</b> chain is used.<br><br>Output connections: <i>Message type connection</i>, <code>Other</code> - if message type is custom or <code>Failure</code>", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbNodeEmptyConfig")
public class TbMsgTypeSwitchNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbMsgTypeSwitchNode.class);
    EmptyNodeConfiguration config;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (EmptyNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, EmptyNodeConfiguration.class);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        ctx.tellNext(msg, msg.getInternalType().getRuleNodeConnection());
    }
}

