/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbJsSwitchNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.script.ScriptLanguage;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="switch", customRelations=true, relationTypes={}, configClazz=TbJsSwitchNodeConfiguration.class, nodeDescription="Routes incoming message to one OR multiple output connections.", nodeDetails="Node executes configured TBEL(recommended) or JavaScript function that returns array of strings (connection names). If Array is empty - message not routed to next Node. Message payload can be accessed via <code>msg</code> property. For example <code>msg.temperature < 10;</code><br/>Message metadata can be accessed via <code>metadata</code> property. For example <code>metadata.customerName === 'John';</code><br/>Message type can be accessed via <code>msgType</code> property.<br><br>Output connections: <i>Custom connection(s) defined by switch node</i> or <code>Failure</code>", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeSwitchConfig")
public class TbJsSwitchNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbJsSwitchNode.class);
    private TbJsSwitchNodeConfiguration config;
    private ScriptEngine scriptEngine;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbJsSwitchNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbJsSwitchNodeConfiguration.class);
        this.scriptEngine = ctx.createScriptEngine(this.config.getScriptLang(), ScriptLanguage.TBEL.equals((Object)this.config.getScriptLang()) ? this.config.getTbelScript() : this.config.getJsScript(), new String[0]);
    }

    public void onMsg(final TbContext ctx, final TbMsg msg) {
        ctx.logJsEvalRequest();
        Futures.addCallback((ListenableFuture)this.scriptEngine.executeSwitchAsync(msg), (FutureCallback)new FutureCallback<Set<String>>(){

            public void onSuccess(@Nullable Set<String> result) {
                ctx.logJsEvalResponse();
                TbJsSwitchNode.this.processSwitch(ctx, msg, result);
            }

            public void onFailure(Throwable t) {
                ctx.logJsEvalFailure();
                ctx.tellFailure(msg, t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void processSwitch(TbContext ctx, TbMsg msg, Set<String> nextRelations) {
        ctx.tellNext(msg, nextRelations);
    }

    public void destroy() {
        if (this.scriptEngine != null) {
            this.scriptEngine.destroy();
        }
    }
}

