/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.ScriptEngine;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbJsFilterNodeConfiguration;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.script.ScriptLanguage;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="script", relationTypes={"True", "False"}, configClazz=TbJsFilterNodeConfiguration.class, nodeDescription="Filter incoming messages using TBEL or JS script", nodeDetails="Evaluates boolean function using incoming message. The function may be written using TBEL or plain JavaScript. Script function should return boolean value and accepts three parameters: <br/>Message payload can be accessed via <code>msg</code> property. For example <code>msg.temperature < 10;</code><br/>Message metadata can be accessed via <code>metadata</code> property. For example <code>metadata.customerName === 'John';</code><br/>Message type can be accessed via <code>msgType</code> property.<br><br>Output connections: <code>True</code>, <code>False</code>, <code>Failure</code>", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeScriptConfig")
public class TbJsFilterNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbJsFilterNode.class);
    private TbJsFilterNodeConfiguration config;
    private ScriptEngine scriptEngine;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbJsFilterNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbJsFilterNodeConfiguration.class);
        this.scriptEngine = ctx.createScriptEngine(this.config.getScriptLang(), ScriptLanguage.TBEL.equals((Object)this.config.getScriptLang()) ? this.config.getTbelScript() : this.config.getJsScript(), new String[0]);
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        ctx.logJsEvalRequest();
        DonAsynchron.withCallback((ListenableFuture)this.scriptEngine.executeFilterAsync(msg), filterResult -> {
            ctx.logJsEvalResponse();
            ctx.tellNext(msg, filterResult != false ? "True" : "False");
        }, t -> {
            ctx.tellFailure(msg, t);
            ctx.logJsEvalFailure();
        }, (Executor)ctx.getDbCallbackExecutor());
    }

    public void destroy() {
        if (this.scriptEngine != null) {
            this.scriptEngine.destroy();
        }
    }
}

