/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DonAsynchron;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbCheckRelationNodeConfiguration;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="check relation presence", configClazz=TbCheckRelationNodeConfiguration.class, version=1, relationTypes={"True", "False"}, nodeDescription="Checks the presence of the relation between the originator of the message and other entities.", nodeDetails="If 'check relation to specific entity' is selected, you should specify a related entity. Otherwise, the rule node checks the presence of a relation to any entity. In both cases, relation lookup is based on configured direction and type.<br><br>Output connections: <code>True</code>, <code>False</code>, <code>Failure</code>", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeCheckRelationConfig")
public class TbCheckRelationNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbCheckRelationNode.class);
    private static final String DIRECTION_PROPERTY_NAME = "direction";
    private TbCheckRelationNodeConfiguration config;
    private EntityId singleEntityId;

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbCheckRelationNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCheckRelationNodeConfiguration.class);
        if (this.config.isCheckForSingleEntity()) {
            if (StringUtils.isEmpty((String)this.config.getEntityType()) || StringUtils.isEmpty((String)this.config.getEntityId())) {
                throw new TbNodeException("Entity should be specified!");
            }
            this.singleEntityId = EntityIdFactory.getByTypeAndId((String)this.config.getEntityType(), (String)this.config.getEntityId());
            ctx.checkTenantEntity(this.singleEntityId);
        }
    }

    public void onMsg(TbContext ctx, TbMsg msg) throws TbNodeException {
        ListenableFuture<Boolean> checkRelationFuture = this.config.isCheckForSingleEntity() ? this.processSingle(ctx, msg) : this.processList(ctx, msg);
        DonAsynchron.withCallback(checkRelationFuture, filterResult -> ctx.tellNext(msg, filterResult != false ? "True" : "False"), t -> ctx.tellFailure(msg, t), (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> processSingle(TbContext ctx, TbMsg msg) {
        EntityId from;
        EntityId to;
        if (EntitySearchDirection.FROM.name().equals(this.config.getDirection())) {
            to = this.singleEntityId;
            from = msg.getOriginator();
        } else {
            from = this.singleEntityId;
            to = msg.getOriginator();
        }
        return ctx.getRelationService().checkRelationAsync(ctx.getTenantId(), from, to, this.config.getRelationType(), RelationTypeGroup.COMMON);
    }

    private ListenableFuture<Boolean> processList(TbContext ctx, TbMsg msg) {
        ListenableFuture relationListFuture = EntitySearchDirection.FROM.name().equals(this.config.getDirection()) ? ctx.getRelationService().findByFromAndTypeAsync(ctx.getTenantId(), msg.getOriginator(), this.config.getRelationType(), RelationTypeGroup.COMMON) : ctx.getRelationService().findByToAndTypeAsync(ctx.getTenantId(), msg.getOriginator(), this.config.getRelationType(), RelationTypeGroup.COMMON);
        return Futures.transformAsync((ListenableFuture)relationListFuture, this::isEmptyList, (Executor)ctx.getDbCallbackExecutor());
    }

    private ListenableFuture<Boolean> isEmptyList(List<EntityRelation> entityRelations) {
        return entityRelations.isEmpty() ? Futures.immediateFuture((Object)false) : Futures.immediateFuture((Object)true);
    }

    public TbPair<Boolean, JsonNode> upgrade(int fromVersion, JsonNode oldConfiguration) throws TbNodeException {
        if (fromVersion == 0) {
            ObjectNode newConfigObjectNode = (ObjectNode)oldConfiguration;
            if (!newConfigObjectNode.has(DIRECTION_PROPERTY_NAME)) {
                throw new TbNodeException("property to update: 'direction' doesn't exists in configuration!");
            }
            String direction = newConfigObjectNode.get(DIRECTION_PROPERTY_NAME).asText();
            if (EntitySearchDirection.TO.name().equals(direction)) {
                newConfigObjectNode.put(DIRECTION_PROPERTY_NAME, EntitySearchDirection.FROM.name());
                return new TbPair((Object)true, (Object)newConfigObjectNode);
            }
            if (EntitySearchDirection.FROM.name().equals(direction)) {
                newConfigObjectNode.put(DIRECTION_PROPERTY_NAME, EntitySearchDirection.TO.name());
                return new TbPair((Object)true, (Object)newConfigObjectNode);
            }
            throw new TbNodeException("property to update: 'direction' has invalid value!");
        }
        return new TbPair((Object)false, (Object)oldConfiguration);
    }
}

