/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.filter;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.filter.TbCheckAlarmStatusNodeConfig;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.msg.TbMsg;

@RuleNode(type=ComponentType.FILTER, name="alarm status filter", configClazz=TbCheckAlarmStatusNodeConfig.class, relationTypes={"True", "False"}, nodeDescription="Checks alarm status.", nodeDetails="Checks the alarm status to match one of the specified statuses.<br><br>Output connections: <code>True</code>, <code>False</code>, <code>Failure</code>.", uiResources={"static/rulenode/rulenode-core-config.js"}, configDirective="tbFilterNodeCheckAlarmStatusConfig")
public class TbCheckAlarmStatusNode
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(TbCheckAlarmStatusNode.class);
    private TbCheckAlarmStatusNodeConfig config;

    public void init(TbContext tbContext, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (TbCheckAlarmStatusNodeConfig)TbNodeUtils.convert((TbNodeConfiguration)configuration, TbCheckAlarmStatusNodeConfig.class);
    }

    public void onMsg(final TbContext ctx, final TbMsg msg) throws TbNodeException {
        try {
            Alarm alarm = (Alarm)JacksonUtil.fromString((String)msg.getData(), Alarm.class);
            ListenableFuture latest = ctx.getAlarmService().findAlarmByIdAsync(ctx.getTenantId(), alarm.getId());
            Futures.addCallback((ListenableFuture)latest, (FutureCallback)new FutureCallback<Alarm>(){

                public void onSuccess(@Nullable Alarm result) {
                    if (result == null) {
                        ctx.tellFailure(msg, (Throwable)new TbNodeException("No such alarm found."));
                        return;
                    }
                    boolean isPresent = TbCheckAlarmStatusNode.this.config.getAlarmStatusList().stream().anyMatch(alarmStatus -> result.getStatus() == alarmStatus);
                    ctx.tellNext(msg, isPresent ? "True" : "False");
                }

                public void onFailure(Throwable t) {
                    ctx.tellFailure(msg, t);
                }
            }, (Executor)ctx.getDbCallbackExecutor());
        }
        catch (Exception e) {
            log.error("Failed to parse alarm: [{}]", (Object)msg.getData());
            throw new TbNodeException(e);
        }
    }
}

