/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.external;

import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class TbAbstractExternalNode
implements TbNode {
    private boolean forceAck;

    public void init(TbContext ctx) {
        this.forceAck = ctx.isExternalNodeForceAck();
    }

    protected void tellSuccess(TbContext ctx, TbMsg tbMsg) {
        if (this.forceAck) {
            ctx.enqueueForTellNext(tbMsg.copyWithNewCtx(), "Success");
        } else {
            ctx.tellSuccess(tbMsg);
        }
    }

    protected void tellFailure(TbContext ctx, TbMsg tbMsg, Throwable t) {
        if (this.forceAck) {
            if (t == null) {
                ctx.enqueueForTellNext(tbMsg.copyWithNewCtx(), "Failure");
            } else {
                ctx.enqueueForTellFailure(tbMsg.copyWithNewCtx(), t);
            }
        } else if (t == null) {
            ctx.tellNext(tbMsg, "Failure");
        } else {
            ctx.tellFailure(tbMsg, t);
        }
    }

    protected TbMsg ackIfNeeded(TbContext ctx, TbMsg msg) {
        if (this.forceAck) {
            ctx.ack(msg);
            return msg.copyWithNewCtx();
        }
        return msg;
    }
}

