/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.edge;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.TbContext;
import org.thingsboard.rule.engine.api.TbNode;
import org.thingsboard.rule.engine.api.TbNodeConfiguration;
import org.thingsboard.rule.engine.api.TbNodeException;
import org.thingsboard.rule.engine.api.util.TbNodeUtils;
import org.thingsboard.rule.engine.edge.BaseTbMsgPushNodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.msg.TbMsg;

public abstract class AbstractTbMsgPushNode<T extends BaseTbMsgPushNodeConfiguration, S, U>
implements TbNode {
    private static final Logger log = LoggerFactory.getLogger(AbstractTbMsgPushNode.class);
    protected T config;
    private static final String SCOPE = "scope";

    public void init(TbContext ctx, TbNodeConfiguration configuration) throws TbNodeException {
        this.config = (BaseTbMsgPushNodeConfiguration)TbNodeUtils.convert((TbNodeConfiguration)configuration, this.getConfigClazz());
    }

    public void onMsg(TbContext ctx, TbMsg msg) {
        if (this.getIgnoredMessageSource().equalsIgnoreCase(msg.getMetaData().getValue("source"))) {
            log.debug("Ignoring msg from the {}, msg [{}]", (Object)this.getIgnoredMessageSource(), (Object)msg);
            ctx.ack(msg);
            return;
        }
        if (this.isSupportedMsgType(msg)) {
            this.processMsg(ctx, msg);
        } else {
            String errMsg = String.format("Unsupported msg type %s", msg.getType());
            log.debug(errMsg);
            ctx.tellFailure(msg, (Throwable)new RuntimeException(errMsg));
        }
    }

    protected S buildEvent(TbMsg msg, TbContext ctx) {
        if (msg.isTypeOf(TbMsgType.ALARM)) {
            EdgeEventActionType actionType = AbstractTbMsgPushNode.getAlarmActionType(msg);
            return this.buildEvent(ctx.getTenantId(), actionType, this.getUUIDFromMsgData(msg), this.getAlarmEventType(), null);
        }
        Map metadata = msg.getMetaData().getData();
        EdgeEventActionType actionType = this.getEdgeEventActionTypeByMsgType(msg);
        HashMap<String, Object> entityBody = new HashMap<String, Object>();
        JsonNode dataJson = JacksonUtil.toJsonNode((String)msg.getData());
        switch (actionType) {
            case ATTRIBUTES_UPDATED: 
            case POST_ATTRIBUTES: {
                entityBody.put("kv", dataJson);
                entityBody.put(SCOPE, this.getScope(metadata));
                if (!EdgeEventActionType.POST_ATTRIBUTES.equals((Object)actionType)) break;
                entityBody.put("isPostAttributes", true);
                break;
            }
            case ATTRIBUTES_DELETED: {
                List keys = (List)JacksonUtil.convertValue((Object)dataJson.get("attributes"), (TypeReference)new TypeReference<List<String>>(){});
                entityBody.put("keys", keys);
                entityBody.put(SCOPE, this.getScope(metadata));
                break;
            }
            case TIMESERIES_UPDATED: {
                entityBody.put("data", dataJson);
                entityBody.put("ts", msg.getMetaDataTs());
            }
        }
        return this.buildEvent(ctx.getTenantId(), actionType, msg.getOriginator().getId(), this.getEventTypeByEntityType(msg.getOriginator().getEntityType()), JacksonUtil.valueToTree(entityBody));
    }

    private static EdgeEventActionType getAlarmActionType(TbMsg msg) {
        boolean isNewAlarm = Boolean.parseBoolean(msg.getMetaData().getValue("isNewAlarm"));
        boolean isClearedAlarm = Boolean.parseBoolean(msg.getMetaData().getValue("isClearedAlarm"));
        EdgeEventActionType eventAction = isNewAlarm ? EdgeEventActionType.ADDED : (isClearedAlarm ? EdgeEventActionType.ALARM_CLEAR : EdgeEventActionType.UPDATED);
        return eventAction;
    }

    abstract S buildEvent(TenantId var1, EdgeEventActionType var2, UUID var3, U var4, JsonNode var5);

    abstract U getEventTypeByEntityType(EntityType var1);

    abstract U getAlarmEventType();

    abstract String getIgnoredMessageSource();

    protected abstract Class<T> getConfigClazz();

    abstract void processMsg(TbContext var1, TbMsg var2);

    protected UUID getUUIDFromMsgData(TbMsg msg) {
        Alarm alarm = (Alarm)JacksonUtil.fromString((String)msg.getData(), Alarm.class);
        return alarm != null ? alarm.getUuidId() : null;
    }

    protected String getScope(Map<String, String> metadata) {
        String scope = metadata.get(SCOPE);
        if (StringUtils.isEmpty((String)scope)) {
            scope = ((BaseTbMsgPushNodeConfiguration)this.config).getScope();
        }
        return scope;
    }

    protected EdgeEventActionType getEdgeEventActionTypeByMsgType(TbMsg msg) {
        EdgeEventActionType actionType;
        if (msg.isTypeOneOf(new TbMsgType[]{TbMsgType.POST_TELEMETRY_REQUEST, TbMsgType.TIMESERIES_UPDATED})) {
            actionType = EdgeEventActionType.TIMESERIES_UPDATED;
        } else if (msg.isTypeOf(TbMsgType.ATTRIBUTES_UPDATED)) {
            actionType = EdgeEventActionType.ATTRIBUTES_UPDATED;
        } else if (msg.isTypeOf(TbMsgType.POST_ATTRIBUTES_REQUEST)) {
            actionType = EdgeEventActionType.POST_ATTRIBUTES;
        } else if (msg.isTypeOf(TbMsgType.ATTRIBUTES_DELETED)) {
            actionType = EdgeEventActionType.ATTRIBUTES_DELETED;
        } else if (msg.isTypeOneOf(new TbMsgType[]{TbMsgType.CONNECT_EVENT, TbMsgType.DISCONNECT_EVENT, TbMsgType.ACTIVITY_EVENT, TbMsgType.INACTIVITY_EVENT})) {
            String scope = msg.getMetaData().getValue(SCOPE);
            actionType = StringUtils.isEmpty((String)scope) ? EdgeEventActionType.TIMESERIES_UPDATED : EdgeEventActionType.ATTRIBUTES_UPDATED;
        } else {
            String type = msg.getType();
            log.warn("Unsupported msg type [{}]", (Object)type);
            throw new IllegalArgumentException("Unsupported msg type: " + type);
        }
        return actionType;
    }

    protected boolean isSupportedMsgType(TbMsg msg) {
        return msg.isTypeOneOf(new TbMsgType[]{TbMsgType.POST_TELEMETRY_REQUEST, TbMsgType.POST_ATTRIBUTES_REQUEST, TbMsgType.ATTRIBUTES_UPDATED, TbMsgType.ATTRIBUTES_DELETED, TbMsgType.TIMESERIES_UPDATED, TbMsgType.ALARM, TbMsgType.CONNECT_EVENT, TbMsgType.DISCONNECT_EVENT, TbMsgType.ACTIVITY_EVENT, TbMsgType.INACTIVITY_EVENT, TbMsgType.TO_SERVER_RPC_REQUEST});
    }
}

