/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.debug;

import org.thingsboard.rule.engine.api.NodeConfiguration;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.script.ScriptLanguage;

public class TbMsgGeneratorNodeConfiguration
implements NodeConfiguration<TbMsgGeneratorNodeConfiguration> {
    public static final int UNLIMITED_MSG_COUNT = 0;
    public static final String DEFAULT_SCRIPT = "var msg = { temp: 42, humidity: 77 };\nvar metadata = { data: 40 };\nvar msgType = \"POST_TELEMETRY_REQUEST\";\n\nreturn { msg: msg, metadata: metadata, msgType: msgType };";
    private int msgCount;
    private int periodInSeconds;
    private String originatorId;
    private EntityType originatorType;
    private ScriptLanguage scriptLang;
    private String jsScript;
    private String tbelScript;

    public TbMsgGeneratorNodeConfiguration defaultConfiguration() {
        TbMsgGeneratorNodeConfiguration configuration = new TbMsgGeneratorNodeConfiguration();
        configuration.setMsgCount(0);
        configuration.setPeriodInSeconds(1);
        configuration.setScriptLang(ScriptLanguage.TBEL);
        configuration.setJsScript(DEFAULT_SCRIPT);
        configuration.setTbelScript(DEFAULT_SCRIPT);
        return configuration;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public int getPeriodInSeconds() {
        return this.periodInSeconds;
    }

    public String getOriginatorId() {
        return this.originatorId;
    }

    public EntityType getOriginatorType() {
        return this.originatorType;
    }

    public ScriptLanguage getScriptLang() {
        return this.scriptLang;
    }

    public String getJsScript() {
        return this.jsScript;
    }

    public String getTbelScript() {
        return this.tbelScript;
    }

    public void setMsgCount(int msgCount) {
        this.msgCount = msgCount;
    }

    public void setPeriodInSeconds(int periodInSeconds) {
        this.periodInSeconds = periodInSeconds;
    }

    public void setOriginatorId(String originatorId) {
        this.originatorId = originatorId;
    }

    public void setOriginatorType(EntityType originatorType) {
        this.originatorType = originatorType;
    }

    public void setScriptLang(ScriptLanguage scriptLang) {
        this.scriptLang = scriptLang;
    }

    public void setJsScript(String jsScript) {
        this.jsScript = jsScript;
    }

    public void setTbelScript(String tbelScript) {
        this.tbelScript = tbelScript;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbMsgGeneratorNodeConfiguration)) {
            return false;
        }
        TbMsgGeneratorNodeConfiguration other = (TbMsgGeneratorNodeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMsgCount() != other.getMsgCount()) {
            return false;
        }
        if (this.getPeriodInSeconds() != other.getPeriodInSeconds()) {
            return false;
        }
        String this$originatorId = this.getOriginatorId();
        String other$originatorId = other.getOriginatorId();
        if (this$originatorId == null ? other$originatorId != null : !this$originatorId.equals(other$originatorId)) {
            return false;
        }
        EntityType this$originatorType = this.getOriginatorType();
        EntityType other$originatorType = other.getOriginatorType();
        if (this$originatorType == null ? other$originatorType != null : !this$originatorType.equals(other$originatorType)) {
            return false;
        }
        ScriptLanguage this$scriptLang = this.getScriptLang();
        ScriptLanguage other$scriptLang = other.getScriptLang();
        if (this$scriptLang == null ? other$scriptLang != null : !this$scriptLang.equals(other$scriptLang)) {
            return false;
        }
        String this$jsScript = this.getJsScript();
        String other$jsScript = other.getJsScript();
        if (this$jsScript == null ? other$jsScript != null : !this$jsScript.equals(other$jsScript)) {
            return false;
        }
        String this$tbelScript = this.getTbelScript();
        String other$tbelScript = other.getTbelScript();
        return !(this$tbelScript == null ? other$tbelScript != null : !this$tbelScript.equals(other$tbelScript));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbMsgGeneratorNodeConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMsgCount();
        result = result * 59 + this.getPeriodInSeconds();
        String $originatorId = this.getOriginatorId();
        result = result * 59 + ($originatorId == null ? 43 : $originatorId.hashCode());
        EntityType $originatorType = this.getOriginatorType();
        result = result * 59 + ($originatorType == null ? 43 : $originatorType.hashCode());
        ScriptLanguage $scriptLang = this.getScriptLang();
        result = result * 59 + ($scriptLang == null ? 43 : $scriptLang.hashCode());
        String $jsScript = this.getJsScript();
        result = result * 59 + ($jsScript == null ? 43 : $jsScript.hashCode());
        String $tbelScript = this.getTbelScript();
        result = result * 59 + ($tbelScript == null ? 43 : $tbelScript.hashCode());
        return result;
    }

    public String toString() {
        return "TbMsgGeneratorNodeConfiguration(msgCount=" + this.getMsgCount() + ", periodInSeconds=" + this.getPeriodInSeconds() + ", originatorId=" + this.getOriginatorId() + ", originatorType=" + this.getOriginatorType() + ", scriptLang=" + this.getScriptLang() + ", jsScript=" + this.getJsScript() + ", tbelScript=" + this.getTbelScript() + ")";
    }
}

