/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.rule.engine.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.SslUtil;
import org.thingsboard.rule.engine.credentials.ClientCredentials;
import org.thingsboard.rule.engine.credentials.CredentialsType;
import org.thingsboard.server.common.data.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CertPemCredentials
implements ClientCredentials {
    private static final Logger log = LoggerFactory.getLogger(CertPemCredentials.class);
    public static final String PRIVATE_KEY_ALIAS = "private-key";
    public static final String X_509 = "X.509";
    public static final String CERT_ALIAS_PREFIX = "cert-";
    public static final String CA_CERT_CERT_ALIAS_PREFIX = "caCert-cert-";
    protected String caCert;
    private String cert;
    private String privateKey;
    private String password = "";

    @Override
    public CredentialsType getType() {
        return CredentialsType.CERT_PEM;
    }

    @Override
    public SslContext initSslContext() {
        try {
            SslContextBuilder builder = SslContextBuilder.forClient();
            if (StringUtils.hasLength((String)this.caCert)) {
                builder.trustManager(this.createAndInitTrustManagerFactory());
            }
            if (StringUtils.hasLength((String)this.cert) && StringUtils.hasLength((String)this.privateKey)) {
                builder.keyManager(this.createAndInitKeyManagerFactory());
            }
            return builder.build();
        }
        catch (Exception e) {
            log.error("[{}:{}] Creating TLS factory failed!", new Object[]{this.caCert, this.cert, e});
            throw new RuntimeException("Creating TLS factory failed!", e);
        }
    }

    protected TrustManagerFactory createAndInitTrustManagerFactory() throws Exception {
        List caCerts = SslUtil.readCertFile((String)this.caCert);
        KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        caKeyStore.load(null, null);
        for (X509Certificate caCert : caCerts) {
            caKeyStore.setCertificateEntry(CA_CERT_CERT_ALIAS_PREFIX + caCert.getSubjectDN().getName(), caCert);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(caKeyStore);
        return trustManagerFactory;
    }

    private KeyManagerFactory createAndInitKeyManagerFactory() throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(this.loadKeyStore(), this.password.toCharArray());
        return kmf;
    }

    protected KeyStore loadKeyStore() throws Exception {
        List certificates = SslUtil.readCertFile((String)this.cert);
        PrivateKey privateKey = SslUtil.readPrivateKey((String)this.privateKey, (String)this.password);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        List unique = certificates.stream().distinct().collect(Collectors.toList());
        for (X509Certificate cert : unique) {
            keyStore.setCertificateEntry(CERT_ALIAS_PREFIX + cert.getSubjectDN().getName(), cert);
        }
        if (privateKey != null) {
            CertificateFactory factory = CertificateFactory.getInstance(X_509);
            CertPath certPath = factory.generateCertPath(certificates);
            List<? extends Certificate> path = certPath.getCertificates();
            Certificate[] x509Certificates = path.toArray(new Certificate[0]);
            keyStore.setKeyEntry(PRIVATE_KEY_ALIAS, privateKey, this.password.toCharArray(), x509Certificates);
        }
        return keyStore;
    }

    public String getCaCert() {
        return this.caCert;
    }

    public String getCert() {
        return this.cert;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPassword() {
        return this.password;
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertPemCredentials)) {
            return false;
        }
        CertPemCredentials other = (CertPemCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$caCert = this.getCaCert();
        String other$caCert = other.getCaCert();
        if (this$caCert == null ? other$caCert != null : !this$caCert.equals(other$caCert)) {
            return false;
        }
        String this$cert = this.getCert();
        String other$cert = other.getCert();
        if (this$cert == null ? other$cert != null : !this$cert.equals(other$cert)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CertPemCredentials;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $caCert = this.getCaCert();
        result = result * 59 + ($caCert == null ? 43 : $caCert.hashCode());
        String $cert = this.getCert();
        result = result * 59 + ($cert == null ? 43 : $cert.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "CertPemCredentials(caCert=" + this.getCaCert() + ", cert=" + this.getCert() + ", privateKey=" + this.getPrivateKey() + ", password=" + this.getPassword() + ")";
    }
}

